/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.upgrade.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.mservice.upgrade.AccountBalanceMergeUpgradeServiceImpl;

public class MergeAccountBalanceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MergeAccountBalanceTask.class);
    private static final int THREAD_NUMS = 5;
    private static final int MAX_ERROR_TIMES = 3;
    private static DBRoute route = DBRoute.of((String)"taxc");
    private static String servicename = MergeAccountBalanceTask.class.getName();
    private int progress = 0;

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (this.progress < progress) {
            this.progress = progress;
        }
        if (this.progress > 100) {
            this.progress = 100;
        } else if (this.progress < 0) {
            this.progress = 0;
        }
    }

    public int getAndSetProgress(int progress) {
        this.setProgress(progress);
        return this.getProgress();
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.execSqlTaskOnProgress();
    }

    private void execSqlTaskOnProgress() {
        long beginTime = System.currentTimeMillis();
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"MergeAccountBalanceTask_0", (String)"taxc-tdm-mservice", (Object[])new Object[0]), null);
        AccountBalanceMergeUpgradeServiceImpl accountBalanceMergeUpgradeService = new AccountBalanceMergeUpgradeServiceImpl();
        String splitTableName = accountBalanceMergeUpgradeService.getSplitTablename();
        Map<Integer, Object[]> params = accountBalanceMergeUpgradeService.getExecSqlParams(splitTableName, "fid");
        this.feedbackProgress(this.getAndSetProgress(5));
        String switchName = accountBalanceMergeUpgradeService.getSwitchName();
        logger.info(switchName + "\u83b7\u53d6\u5206\u6279\u7684\u8d77\u6b62id\u96c6\u5408\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
        logger.info(switchName + "\u603b\u6279\u6b21\uff1a" + params.size());
        boolean execResult = false;
        if (accountBalanceMergeUpgradeService.isIgnoreExecUpgrade(switchName)) {
            execResult = true;
            this.feedbackProgress(this.getAndSetProgress(100));
        } else {
            if (EmptyCheckUtils.isEmpty(params)) {
                execResult = true;
                this.feedbackProgress(this.getAndSetProgress(100));
            } else if (params.size() == 1) {
                DB.execute((DBRoute)route, (String)accountBalanceMergeUpgradeService.getSingleUpdateSql());
                execResult = true;
                this.feedbackProgress(this.getAndSetProgress(100));
            } else {
                execResult = this.executeSplitSql(accountBalanceMergeUpgradeService.getSplitUpdateSql(), params);
            }
            logger.info(switchName + "\u603b\u6279\u6b21\u6267\u884c\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
        }
        this.checkIsStop();
        accountBalanceMergeUpgradeService.updateSwitch(switchName);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", execResult);
        this.feedbackCustomdata(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSplitSql(String splitUpdateSql, Map<Integer, Object[]> params) {
        int size = params.size();
        try (ThreadPool pool = null;){
            String tenantId = "Default";
            RequestContextInfo rci = RequestContextInfo.get();
            if (rci != null) {
                tenantId = rci.getTenantId();
            }
            String poolname = tenantId + '.' + servicename;
            pool = ThreadPools.newCachedThreadPool((String)poolname, (int)5, (int)10);
            HashSet<Integer> execIndexes = new HashSet<Integer>(5);
            int errtimes = 0;
            while (!params.isEmpty()) {
                if (errtimes >= 3) {
                    StringBuilder errlogBuilder = new StringBuilder(servicename).append(" error:");
                    params.values().forEach(param -> errlogBuilder.append(Arrays.toString(param)));
                    errlogBuilder.append(splitUpdateSql);
                    String errlog = errlogBuilder.toString();
                    logger.error(errlog);
                    boolean bl = false;
                    return bl;
                }
                execIndexes.clear();
                int firstIndex = 0;
                for (int i = 1; i <= 2; ++i) {
                    for (int j = 1; j <= size && (i != 2 || j < firstIndex); ++j) {
                        if (params.containsKey(j)) {
                            if (firstIndex == 0) {
                                firstIndex = j;
                            }
                            execIndexes.add(j);
                        }
                        if (execIndexes.size() != 5) continue;
                        this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                        execIndexes.clear();
                        firstIndex = 0;
                    }
                }
                if (execIndexes.size() > 0) {
                    this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                }
                ++errtimes;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void concurrentHandleSql(ThreadPool pool, final String sql, Map<Integer, Object[]> params, Set<Integer> execIndexes) {
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(5);
        final int[] percent = new int[]{8};
        this.feedbackProgress(8);
        final int step = 100 / execIndexes.size();
        Iterator<Object> iterator = execIndexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            final Object[] param = params.get(n);
            Future future = pool.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    StringBuilder execBuilder = new StringBuilder(servicename).append(" exec:").append(Arrays.toString(param)).append(sql);
                    long beginTime = System.currentTimeMillis();
                    logger.info(execBuilder.toString());
                    DB.execute((DBRoute)route, (String)sql, (Object[])param);
                    percent[0] = percent[0] + step;
                    if (percent[0] >= 100) {
                        percent[0] = 99;
                    }
                    MergeAccountBalanceTask.this.feedbackProgress(percent[0]);
                    logger.info("\u5355\u6279\u6267\u884c\u7684\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
                    return true;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            try {
                if (!((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                params.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.info(e.toString());
                for (StackTraceElement trace : e.getStackTrace()) {
                    logger.info(trace.toString());
                }
            }
        }
    }
}

