/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class AssetCardConfirmOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject[] cards = BusinessDataServiceHelper.load((Object[])Arrays.stream(this.dataEntities).map(e -> e.getDataEntity().getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card"));
                Map<Long, DynamicObject> objectMap = Arrays.stream(cards).collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (k1, k2) -> k1));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject object = dataEntity.getDataEntity();
                    DynamicObject object1 = objectMap.get(object.getLong("id"));
                    DynamicObject taxassetclass = object1.getDynamicObject("taxassetclass");
                    DynamicObject taxdepreciation = object1.getDynamicObject("taxdepreciation");
                    int taxamortizationperiods = object1.getInt("taxamortizationperiods");
                    String depreciationadjustmethod = object1.getString("depreciationadjustmethod");
                    if (taxassetclass == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u9700\u586b\u5199\u3010\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b\u3011\u3002", (String)"AssetCardConfirmOpPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if (taxdepreciation == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u9700\u586b\u5199\u3010\u7a0e\u52a1\u6298\u65e7\u65b9\u6cd5\u3011\u3002", (String)"AssetCardConfirmOpPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if (taxamortizationperiods == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u9700\u586b\u5199\u3010\u7a0e\u52a1\u9884\u8ba1\u6298\u65e7\u644a\u9500\u671f\u6570\u3011\u3002", (String)"AssetCardConfirmOpPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if (!StringUtil.isBlank((CharSequence)depreciationadjustmethod)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u9700\u586b\u5199\u3010\u6298\u65e7\u8c03\u6574\u65b9\u5f0f\u3011\u3002", (String)"AssetCardConfirmOpPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

