/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;

public class AssetCardSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject object = dataEntity.getDataEntity();
                    DynamicObject taxorg = object.getDynamicObject("taxorg");
                    long taxOrgId = taxorg.getLong("id");
                    DynamicObject accountorg = object.getDynamicObject("accountorg");
                    long accountOrgId = accountorg.getLong("id");
                    DynamicObject taxationsys = object.getDynamicObject("taxationsys");
                    long taxationsysId = taxationsys.getLong("id");
                    Object taxarea = object.get("taxarea");
                    DynamicObject assetdata = object.getDynamicObject("assetdata");
                    TaxResult taxcOrgIdByAccountingOrgIds = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)accountOrgId);
                    List ids = (List)taxcOrgIdByAccountingOrgIds.getData();
                    if (!ids.contains(taxOrgId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AssetCardSaveOpPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject taxorgObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)taxOrgId)});
                    List taxationsysIds = taxorgObject.getDynamicObjectCollection("entryentity").stream().map(e -> e.getDynamicObject("entry_taxationsys").getLong("id")).collect(Collectors.toList());
                    if (!taxationsysIds.contains(taxationsysId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0e\u7a0e\u6536\u5236\u5ea6\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AssetCardSaveOpPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (Objects.nonNull(taxarea)) {
                        Optional<DynamicObject> taxationsysObj = taxorgObject.getDynamicObjectCollection("entryentity").stream().filter(e -> e.getDynamicObject("entry_taxationsys").getLong("id") == taxationsysId).findFirst();
                        if (taxationsysObj.isPresent()) {
                            long taxareaId;
                            List taxareaIds = taxationsysObj.map(dynamicObject -> dynamicObject.getDynamicObjectCollection("entry_taxarea").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
                            if (!taxareaIds.contains(taxareaId = ((DynamicObject)taxarea).getLong("id"))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u6536\u8f96\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AssetCardSaveOpPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                        } else {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u6536\u8f96\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AssetCardSaveOpPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter accountOrgFilter = new QFilter("taxorg", "=", (Object)accountOrgId);
                    DynamicObjectCollection assetDataList = QueryServiceHelper.query((String)"tdm_asset_data", (String)"assetcode", (QFilter[])new QFilter[]{enableFilter, accountOrgFilter});
                    List assetcodeList = assetDataList.stream().map(e -> e.getString("assetcode")).collect(Collectors.toList());
                    if (assetcodeList.contains(assetdata.getString("assetcode"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AssetCardSaveOpPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

