/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.depreciation.TpoDepreciationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AssetTypeMappingSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("taxationsys");
        e.getFieldKeys().add("taxarea");
        e.getFieldKeys().add("entryentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    TaxResult listTaxResult;
                    TaxResult taxationsysTaxResult;
                    DynamicObject object = dataEntity.getDataEntity();
                    DynamicObject taxationsys = object.getDynamicObject("taxationsys");
                    if (taxationsys != null && EmptyCheckUtils.isNotEmpty((Object)(taxationsysTaxResult = TaxAtionsysDataServiceHelper.querySingleTaxAtionsysById((Long)taxationsys.getLong("id"))).getData()) && "0".equals(((DynamicObject)taxationsysTaxResult.getData()).getString("enable"))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u5236\u5ea6\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AssetTypeMappingSaveOpPlugin_7", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject taxarea = object.getDynamicObject("taxarea");
                    TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
                    if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData()))) {
                        List areaAvailableGroupIds = ((List)taxareaTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                        if (taxarea != null && !areaAvailableGroupIds.contains(taxarea.getLong("id"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AssetTypeMappingSaveOpPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    } else {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AssetTypeMappingSaveOpPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (taxationsys != null && (listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)taxationsys.getLong("countryid.id"))) != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                        List areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                        if (taxarea != null && !areaGroupIds.contains(taxarea.getLong("id"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u6536\u8f96\u533a\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AssetTypeMappingSaveOpPlugin_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (!object.containsProperty("entryentity")) continue;
                    Long taxationsysId = taxationsys != null ? Long.valueOf(taxationsys.getLong("id")) : null;
                    Long taxareaId = taxarea != null ? Long.valueOf(taxarea.getLong("id")) : null;
                    TaxResult ybDepreciationMatchTaxResult = TpoDepreciationServiceHelper.loadTpoYbDepreciationEnable((Long)taxationsysId, (Long)taxareaId);
                    TaxResult ybDepreciationEnableTaxResult = TpoDepreciationServiceHelper.loadTpoYbDepreciationEnable();
                    DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entity : entryentity) {
                        Date startdate = entity.getDate("startdate");
                        Date enddate = entity.getDate("enddate");
                        String taxassetClass = entity.getString("taxassettype.class");
                        if (!this.checkDate(startdate, enddate, dataEntity)) {
                            return;
                        }
                        if (!this.checkTaxassettype(taxassetClass, (TaxResult<List<DynamicObject>>)ybDepreciationEnableTaxResult)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b\u6240\u5c5e\u7684\u4e00\u822c\u6298\u65e7\u653f\u7b56\u5df2\u88ab\u7981\u7528\u3002", (String)"AssetTypeMappingSaveOpPlugin_8", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (this.checkTaxassettype(taxassetClass, (TaxResult<List<DynamicObject>>)ybDepreciationMatchTaxResult)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u6536\u8f96\u533a\u548c\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"AssetTypeMappingSaveOpPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (entryentity.size() <= 1) continue;
                    Map<String, List<DynamicObject>> entryentityGroupByType = entryentity.stream().collect(Collectors.groupingBy(p -> p.getString("taxassettype") + "_" + p.getString("accountassettype")));
                    for (Map.Entry<String, List<DynamicObject>> entry : entryentityGroupByType.entrySet()) {
                        if (this.checkDate(entry.getValue())) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"AssetTypeMappingSaveOpPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }

            private boolean checkTaxassettype(String taxassetClass, TaxResult<List<DynamicObject>> ybDepreciationEnableTaxResult) {
                if (ybDepreciationEnableTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)ybDepreciationEnableTaxResult.getData()))) {
                    List ybDepreciationEnableClasss = ((List)ybDepreciationEnableTaxResult.getData()).stream().map(o -> o.getString("class")).collect(Collectors.toList());
                    return ybDepreciationEnableClasss.contains(taxassetClass);
                }
                return false;
            }

            private boolean checkDate(Date skssqq, Date skssqz, ExtendedDataEntity dataEntity) {
                if (skssqq == null) {
                    return false;
                }
                int dayOfDate = DateUtils.getDayOfDate((Date)skssqq);
                if (dayOfDate != 1) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d\u3002", (String)"AssetTypeMappingSaveOpPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (skssqz != null) {
                    int dayOfDate2;
                    int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)skssqz));
                    if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)skssqz))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u3002", (String)"AssetTypeMappingSaveOpPlugin_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (skssqq.after(skssqz)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"AssetTypeMappingSaveOpPlugin_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                return true;
            }

            private boolean checkDate(List<DynamicObject> list) {
                if (list.size() > 1) {
                    for (int i = 0; i < list.size(); ++i) {
                        Date startdate = list.get(i).getDate("startdate");
                        Date enddate = list.get(i).getDate("enddate");
                        for (int j = 0; j < list.size(); ++j) {
                            Date enddate2;
                            Date startdate2;
                            boolean flag;
                            if (i == j || (flag = DateUtils.checkTimeRepeat((Date)startdate, (Date)enddate, (Date)(startdate2 = list.get(j).getDate("startdate")), (Date)(enddate2 = list.get(j).getDate("enddate"))))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }
}

