/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.tdm.business.declaration.algorithm.ExportDeclarationAlgorithmForOp;
import kd.taxc.tdm.business.declaration.util.ExportDeclarationSelectorFactory;

public class DecalarationFormCalmylajOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(ExportDeclarationSelectorFactory.getSelector());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objects = e.getDataEntities();
        ExportDeclarationAlgorithmForOp algorithm = null;
        HashMap cache = new HashMap();
        for (DynamicObject obj : objects) {
            algorithm = new ExportDeclarationAlgorithmForOp(obj, cache);
            algorithm.calculate();
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("calmylaj", "true");
        OperationResult saveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"tdm_export_declaration", (DynamicObject[])e.getDataEntities(), (OperateOption)option);
        this.rebuildOpResult(e, saveOpResult);
    }

    protected void rebuildOpResult(BeginOperationTransactionArgs e, OperationResult saveOpResult) {
        if (!saveOpResult.isSuccess()) {
            ArrayList<OperateErrorInfo> allError = new ArrayList<OperateErrorInfo>(16);
            List allErrorOrValidateInfo = saveOpResult.getAllErrorOrValidateInfo();
            HashMap<Long, Boolean> billErrorMap = new HashMap<Long, Boolean>();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                if (!(iOperateInfo instanceof OperateErrorInfo)) continue;
                OperateErrorInfo error = (OperateErrorInfo)iOperateInfo;
                allError.add(error);
                billErrorMap.put((Long)error.getPkValue(), Boolean.TRUE);
            }
            this.getOperationResult().setAllErrorInfo(allError);
            List<DynamicObject> successObjs = Stream.of(e.getDataEntities()).filter(obj -> !billErrorMap.containsKey(obj.getLong("id"))).collect(Collectors.toList());
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }
}

