/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DeclarationBillUnauditValidator
extends AbstractValidator {
    public void validate() {
        List ids = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("entryentity.writeoffqty", ">", (Object)0L));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"tdm_export_declaration", (String)"id,billno,entryentity.writeoffqty", (QFilter[])new QFilter[]{filter});
        if (colls != null && colls.size() > 0) {
            List numbers = colls.stream().map(s -> s.getString("billno")).distinct().collect(Collectors.toList());
            String errormsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6838\u9500\u6570\u91cf\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclarationBillUnauditValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject currentObj = dataEntity.getDataEntity();
                String billno = currentObj.getString("billno");
                if (!numbers.contains(billno)) continue;
                this.addErrorMessage(dataEntity, errormsg);
            }
        }
    }
}

