/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.taxc.tdm.business.declaration.algorithm.ExportDeclarationAlgorithmForOp;
import kd.taxc.tdm.business.declaration.util.ExportDeclarationSelectorFactory;
import kd.taxc.tdm.opplugin.DeclarationFormSaveValidator;
import org.apache.commons.collections.CollectionUtils;

public class DeclarationFormSaveOp
extends AbstractOperationServicePlugIn {
    public static final String ENTRYENTITY = "entryentity";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(ExportDeclarationSelectorFactory.getSelector());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new DeclarationFormSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objects = e.getDataEntities();
        if (!this.getOption().containsVariable("extendParam")) {
            ExportDeclarationAlgorithmForOp algorithm = null;
            HashMap cache = new HashMap();
            DynamicObject[] dynamicObjectArray = objects;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject obj = dynamicObjectArray[i];
                algorithm = new ExportDeclarationAlgorithmForOp(obj, cache);
                algorithm.calculate();
            }
        }
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objects) {
            Optional<String> result = this.checkAlgorithm(obj);
            if (result.isPresent()) {
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, result.get()));
                continue;
            }
            successObjs.add(obj);
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "errorcode001", "", msg, errorLevel);
        return info;
    }

    private Optional<String> checkAlgorithm(DynamicObject currentObj) {
        DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntitys)) {
            return Optional.empty();
        }
        BigDecimal freightamount = currentObj.getBigDecimal("freightamount");
        BigDecimal premiumamount = currentObj.getBigDecimal("premiumamount");
        BigDecimal sundryamount = currentObj.getBigDecimal("sundryamount");
        BigDecimal totalYfAmount = BigDecimal.ZERO;
        BigDecimal totalBfAmount = BigDecimal.ZERO;
        BigDecimal totalZfAmount = BigDecimal.ZERO;
        boolean hasNegativeMylaj = false;
        for (DynamicObject entry : entryEntitys) {
            totalYfAmount = totalYfAmount.add(entry.getBigDecimal("yfAmount"));
            totalBfAmount = totalBfAmount.add(entry.getBigDecimal("bfAmount"));
            totalZfAmount = totalZfAmount.add(entry.getBigDecimal("zfAmount"));
            if (hasNegativeMylaj || BigDecimal.ZERO.compareTo(entry.getBigDecimal("mylaj")) <= 0) continue;
            hasNegativeMylaj = true;
        }
        if (freightamount.compareTo(totalYfAmount) != 0) {
            return Optional.of(ResManager.loadKDString((String)"\u91d1\u989d\u4fe1\u606f\u548c\u5206\u5f55\u884c\u7684\u201c\u8fd0\u8d39\u91d1\u989d\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeclarationFormSaveOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (premiumamount.compareTo(totalBfAmount) != 0) {
            return Optional.of(ResManager.loadKDString((String)"\u91d1\u989d\u4fe1\u606f\u548c\u5206\u5f55\u884c\u7684\u201c\u4fdd\u8d39\u91d1\u989d\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeclarationFormSaveOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (sundryamount.compareTo(totalZfAmount) != 0) {
            return Optional.of(ResManager.loadKDString((String)"\u91d1\u989d\u4fe1\u606f\u548c\u5206\u5f55\u884c\u7684\u201c\u6742\u8d39\u91d1\u989d\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeclarationFormSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (hasNegativeMylaj) {
            return Optional.of(ResManager.loadKDString((String)"\u7f8e\u5143\u79bb\u5cb8\u4ef7\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeclarationFormSaveOp_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }
}

