/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.collections.CollectionUtils;

public class DeclarationFormSaveValidator
extends AbstractValidator {
    public static final String ENTRYENTITY = "entryentity";

    public void validate() {
        if ("submit".equalsIgnoreCase(this.getOperateKey())) {
            this.checkBeforeSubmit();
        }
    }

    protected void checkBeforeSubmit() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection(ENTRYENTITY);
            if (CollectionUtils.isNotEmpty((Collection)entryEntitys)) {
                Map<String, List<DynamicObject>> itemgroup = entryEntitys.stream().collect(Collectors.groupingBy(s -> s.getString("itemno")));
                for (Map.Entry<String, List<DynamicObject>> row : itemgroup.entrySet()) {
                    if (row.getValue().size() <= 1) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u5b58\u5728\u76f8\u540c\u7684\u9879\u53f7\uff1a%s\u3002", (String)"DeclarationFormSaveValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), row.getKey()));
                }
                continue;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u660e\u7ec6\u201d\u3002", (String)"DeclarationFormSaveValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

