/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.hscode.HscodeDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class ExportDeclarationImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        HashMap<String, DynamicObject> taxcHsCodeCache = new HashMap<String, DynamicObject>();
        block2: while (it.hasNext()) {
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            JSONObject org = data.getData().getJSONObject("org");
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)org.getString("number")).getData()).booleanValue()) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\u3002", (String)"ExportDeclarationImportPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            JSONArray entities = data.getData().getJSONArray("entryentity");
            if (entities == null || entities.size() <= 0) continue;
            for (int i = 0; i < entities.size(); ++i) {
                BigDecimal tradeqty;
                JSONObject obj = entities.getJSONObject(i);
                JSONObject hscodeobj = obj.getJSONObject("hscode");
                if (hscodeobj != null) {
                    Date declarationdate;
                    String hscode = hscodeobj.getString("number");
                    if (StringUtils.isBlank((Object)data.getData().get((Object)"declarationdate"))) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportDeclarationImportPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                        it.remove();
                        continue block2;
                    }
                    try {
                        declarationdate = data.getData().getDate("declarationdate");
                    }
                    catch (Exception e) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExportDeclarationImportPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                        it.remove();
                        continue block2;
                    }
                    JSONObject itemobj = this.queryHscode(hscode, declarationdate, taxcHsCodeCache);
                    if (itemobj != null) {
                        obj.put("hscode", (Object)itemobj);
                    } else {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\u672a\u5339\u914d\u5230\u6570\u636e\u3002", (String)"ExportDeclarationImportPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                        it.remove();
                        continue block2;
                    }
                }
                if ((tradeqty = obj.getBigDecimal("tradeqty")) == null || tradeqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                obj.put("unwriteoffqty", (Object)tradeqty);
            }
        }
        super.beforeSave(billdatas, logger);
    }

    private JSONObject queryHscode(String hscode, Date date, Map<String, DynamicObject> taxcHsCodeCache) {
        if (hscode == null || date == null) {
            return null;
        }
        DynamicObject obj = this.getTaxcHsCodeFromCache(hscode, date, taxcHsCodeCache);
        if (obj != null) {
            JSONObject hsobj = new JSONObject();
            hsobj.put("importprop", (Object)"id");
            hsobj.put("id", (Object)obj.getLong("id"));
            return hsobj;
        }
        return null;
    }

    private DynamicObject getTaxcHsCodeFromCache(String number, Date date, Map<String, DynamicObject> taxcHsCodeCache) {
        String key = String.format("%1$s.%2$tY-%2$tm-%2$te", number, date, taxcHsCodeCache);
        DynamicObject taxcHsCode = taxcHsCodeCache.get(key);
        if (taxcHsCode == null) {
            List data;
            ArrayList<String> numbers = new ArrayList<String>();
            numbers.add(number);
            TaxResult taxResult = HscodeDataServiceHelper.queryTaxcHscodeByNumbers(numbers, (Date)date);
            if (taxResult != null && taxResult.isSuccess() && (data = (List)taxResult.getData()) != null && data.size() > 0) {
                taxcHsCode = (DynamicObject)data.get(0);
                taxcHsCodeCache.put(key, taxcHsCode);
            }
        }
        return taxcHsCode;
    }

    protected boolean isForceBatch() {
        return true;
    }
}

