/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections.CollectionUtils;

public class FinanceTemplateSaveValidator
extends AbstractValidator {
    public static final String ENTRYENTITY = "entryentity";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            Long currentId = currentObj.getLong("id");
            DynamicObject createorg = currentObj.getDynamicObject("createorg");
            DynamicObject type = currentObj.getDynamicObject("templatetype");
            QFilter idFilter = new QFilter("id", "!=", (Object)currentId);
            QFilter orgFilter = new QFilter("createorg", "=", (Object)createorg.getLong("id"));
            QFilter typeFilter = new QFilter("templatetype", "=", (Object)type.getString("id"));
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter[] filters = new QFilter[]{idFilter, typeFilter, orgFilter, enableFilter};
            int count = this.count(((Object)((Object)this)).getClass().getName(), "tdm_finance_template", "id", filters);
            if (count > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u4e00\u4e2a\u53ef\u7528\u7684\u3010%s\u3011\u6a21\u677f\u3002", (String)"FinanceTemplateSaveValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), type.getString("name")));
                return;
            }
            DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection(ENTRYENTITY);
            if (!CollectionUtils.isNotEmpty((Collection)entryEntitys)) continue;
            Map<String, List<DynamicObject>> itemgroup = entryEntitys.stream().collect(Collectors.groupingBy(s -> s.getString("item.number")));
            for (Map.Entry<String, List<DynamicObject>> row : itemgroup.entrySet()) {
                if (row.getValue().size() <= 1) continue;
                String name = row.getValue().get(0).getString("item.name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinanceTemplateSaveValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), name));
                return;
            }
            Map<String, List<DynamicObject>> rownumbergroup = entryEntitys.stream().collect(Collectors.groupingBy(s -> s.getString("rownumber")));
            for (Map.Entry<String, List<DynamicObject>> row : rownumbergroup.entrySet()) {
                if (row.getValue().size() <= 1) continue;
                String rownumber = row.getKey();
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u6b21\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinanceTemplateSaveValidator_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), rownumber));
                return;
            }
        }
    }

    private int count(String className, String entityName, String fieldKey, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count(className, entityName, fieldKey, filters);
    }
}

