/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class HighTechIPRSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                Long currUserId = RequestContext.get().getCurrUserId();
                TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)currUserId);
                List data = (List)listTaxResult.getData();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject taxOrg;
                    String getWay;
                    DynamicObject info = dataEntity.getDataEntity();
                    Date accreditDate = info.getDate("accreditdate");
                    Date dueDate = info.getDate("duedate");
                    if (accreditDate != null && dueDate != null && accreditDate.compareTo(dueDate) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u6743\u65e5\u671f\u8981\u65e9\u4e8e\u77e5\u8bc6\u4ea7\u6743\u5230\u671f\u65e5\u671f", (String)"HighTechIPRSaveOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if ("B".equals(getWay = info.getString("getway"))) {
                        String transferor = info.getString("transferor");
                        Date transferDate = info.getDate("transferdate");
                        if (transferor == null || "".equals(transferor) || transferDate == null) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u83b7\u5f97\u65b9\u5f0f\u4e3a\u8f6c\u8ba9\u65f6\uff0c\u9700\u586b\u5199\u51fa\u8ba9\u65b9\u548c\u51fa\u8ba9\u65e5\u671f", (String)"HighTechIPRSaveOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if ((taxOrg = info.getDynamicObject("taxorg")) == null || data != null && data.contains(taxOrg.getLong("id"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"HighTechIPRSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

