/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class HighTechPersonSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("taxorg");
        e.getFieldKeys().add("leavetime");
        e.getFieldKeys().add("entrytime");
        e.getFieldKeys().add("user");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                Long currUserId = RequestContext.get().getCurrUserId();
                TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)currUserId);
                List data = (List)listTaxResult.getData();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject user;
                    DynamicObject info = dataEntity.getDataEntity();
                    DynamicObject taxOrg = info.getDynamicObject("taxorg");
                    if (!(taxOrg == null || data != null && data.contains(taxOrg.getLong("id")))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"HighTechPersonSaveOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    Date leaveTime = info.getDate("leavetime");
                    Date entryTime = info.getDate("entrytime");
                    if (leaveTime != null && leaveTime.compareTo(entryTime) < 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79bb\u804c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5165\u804c\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HighTechPersonSaveOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if ((user = info.getDynamicObject("user")) == null || user.getBoolean("enable")) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u4eba\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"HighTechPersonSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

