/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;

public class NoiseInfoImportPlugin
extends BatchImportPlugin {
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        boolean notAuthorize;
        String org = data.getData().getJSONObject("org").getString("number");
        DynamicObject dynamicObject = NoiseInfoImportPlugin.loadTaxMain(org);
        if (dynamicObject != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)dynamicObject.getLong("orgid"), null, (String)"tcret"))) {
            message.append(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u8bb8\u53ef", (String)"NoiseInfoImportPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), org));
            return;
        }
        Long orgid = this.validOrg(org, message);
        if (null == orgid) {
            return;
        }
        if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgid).isSuccess()) {
            message.append(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"NoiseInfoImportPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), org));
            return;
        }
        DynamicObject source = this.sourceNumber(data.getData(), orgid, message);
        if (null == source) {
            return;
        }
        JSONObject pfksszgswjg = new JSONObject();
        pfksszgswjg.put("importprop", (Object)"id");
        pfksszgswjg.put("id", source.get("pfksszgswjg"));
        data.getData().put("taxauthority", (Object)pfksszgswjg);
        data.getData().put("datasource", (Object)"2");
        boolean present = this.isPresent(data, orgid, source, message);
        if (present) {
            return;
        }
        this.fbMonitor(data.getData(), message);
        this.setDefaultData(data);
        this.checkFBexc(data, message);
    }

    private boolean isPresent(ImportBillData data, Long org, DynamicObject source, StringBuilder message) {
        QFilter filter = new QFilter("org", "=", (Object)org).and("sourcenumber", "=", (Object)source.getLong("id")).and("sourcenumber.pfknum", "=", (Object)data.getData().getJSONObject("sourcenumber").getString("pfknum")).and("month", "=", (Object)data.getData().getDate("month"));
        if (QueryServiceHelper.exists((String)"tdm_noise_info", (QFilter[])new QFilter[]{filter})) {
            message.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u67e5\u770b\u5df2\u5f55\u5165\u4fe1\u606f\u3002", (String)"NoiseInfoImportPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (data.getData().getIntValue("zjstand") < 0) {
            message.append(ResManager.loadKDString((String)"\u201c\u6807\u51c6\u503c-\u663c\u95f4\u201d\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c\u3002", (String)"NoiseInfoImportPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (data.getData().getIntValue("yjstand") < 0) {
            message.append(ResManager.loadKDString((String)"\u201c\u6807\u51c6\u503c-\u591c\u95f4\u201d\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c\u3002", (String)"NoiseInfoImportPlugin_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return true;
        }
        JSONArray entryentity = data.getData().getJSONArray("entryentity");
        if (entryentity != null) {
            for (Object entry : entryentity) {
                JSONObject obj = (JSONObject)entry;
                if (obj.getIntValue("jcfbs") >= 0) continue;
                message.append(ResManager.loadKDString((String)"\u201c\u76d1\u6d4b\u5206\u8d1d\u6570\u201d\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c\u3002", (String)"NoiseInfoImportPlugin_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private Long validOrg(String orgNumber, StringBuilder message) {
        QFilter orgFilter = new QFilter("org.number", "=", (Object)orgNumber);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        if (null == org) {
            message.append(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"NoiseInfoImportPlugin_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), orgNumber));
            return null;
        }
        TaxResult hbsCard = TaxcMainDataServiceHelper.isTaxcMainHjbhsEnableByOrgId((Long)org.getLong("id"));
        if (hbsCard == null || !((Boolean)hbsCard.getData()).booleanValue()) {
            message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u542f\u7528\u73af\u5883\u4fdd\u62a4\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8d44\u6599>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u7684\u7a0e\u79cd\u4fe1\u606f\u4e2d\u8fdb\u884c\u914d\u7f6e\u3002", (String)"NoiseInfoImportPlugin_7", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), orgNumber));
            return null;
        }
        return org.getLong("id");
    }

    private DynamicObject sourceNumber(JSONObject data, Long org, StringBuilder message) {
        String sourceNumber = data.getJSONObject("sourcenumber").getString("number");
        Date month = data.getDate("month");
        String pfknum = null == data.getJSONObject("sourcenumber").getString("pfknum") ? "" : data.getJSONObject("sourcenumber").getString("pfknum");
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and(new QFilter("number", "=", (Object)sourceNumber));
        filter.and(new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769730L));
        DynamicObjectCollection source = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,startdate,enddate,pfknum,pfksszgswjg ", (QFilter[])new QFilter[]{filter});
        if (source.size() == 0) {
            message.append(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5f55\u5165\u8be5\u7a0e\u6e90\u7f16\u53f7", (String)"NoiseInfoImportPlugin_8", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return null;
        }
        List collect = source.stream().filter(s -> DateUtils.isEffectiveDate((Date)month, (Date)DateUtils.getFirstDateOfMonth((Date)s.getDate("startdate")), (Date)DateUtils.getLastDateOfMonth((Date)s.getDate("enddate")))).collect(Collectors.toList());
        if (collect.size() == 0) {
            message.append(ResManager.loadKDString((String)"\u8be5\u7a0e\u6e90\u7f16\u53f7\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165", (String)"NoiseInfoImportPlugin_9", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            return null;
        }
        List pfknum1 = collect.stream().filter(c -> c.getString("pfknum").equals(pfknum)).collect(Collectors.toList());
        if (pfknum1.size() == 0) {
            message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6e90%1$s\u4e0d\u5b58\u5728%2$s\u6392\u653e\u53e3\u7f16\u53f7", (String)"NoiseInfoImportPlugin_10", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), sourceNumber, pfknum));
            return null;
        }
        return (DynamicObject)pfknum1.get(0);
    }

    private void fbMonitor(JSONObject data, StringBuilder message) {
        int zjstand = Integer.parseInt(data.getString("zjstand"));
        int yjstand = Integer.parseInt(data.getString("yjstand"));
        JSONArray entryentity = data.getJSONArray("entryentity");
        if (entryentity != null) {
            for (Object entry : entryentity) {
                JSONObject obj = (JSONObject)entry;
                String noisetime = obj.getString("zysd");
                int fbmonitor = Integer.parseInt(obj.getString("jcfbs"));
                switch (noisetime) {
                    case "day": {
                        obj.put("cbfbs", (Object)(fbmonitor - zjstand));
                        if (fbmonitor > zjstand) break;
                        message.append(ResManager.loadKDString((String)"\u5f53\u524d\u566a\u58f0\u6e90\u76d1\u6d4b\u566a\u58f0\u672a\u8d85\u8fc7\u89c4\u5b9a\u6807\u51c6\u3002", (String)"NoiseInfoImportPlugin_11", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "night": {
                        obj.put("cbfbs", (Object)(fbmonitor - yjstand));
                        if (fbmonitor > yjstand) break;
                        message.append(ResManager.loadKDString((String)"\u5f53\u524d\u566a\u58f0\u6e90\u76d1\u6d4b\u566a\u58f0\u672a\u8d85\u8fc7\u89c4\u5b9a\u6807\u51c6\u3002", (String)"NoiseInfoImportPlugin_11", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private void setDefaultData(ImportBillData data) {
        JSONArray entryentity = data.getData().getJSONArray("entryentity");
        if (entryentity != null) {
            for (Object entry : entryentity) {
                JSONObject obj = (JSONObject)entry;
                Boolean overlimit = obj.getBoolean("cbbzswt");
                BigDecimal cbbzswtrate = Boolean.TRUE.equals(overlimit) ? new BigDecimal("0.5") : new BigDecimal("1");
                Boolean multi = obj.getBoolean("lcyszycb");
                BigDecimal lcyszycbrate = Boolean.TRUE.equals(multi) ? new BigDecimal("2") : new BigDecimal("1");
                obj.put("cbbzswtrate", (Object)cbbzswtrate);
                obj.put("lcyszycbrate", (Object)lcyszycbrate);
                obj.put("jsyj", (Object)cbbzswtrate.multiply(lcyszycbrate).setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private void checkFBexc(ImportBillData data, StringBuilder message) {
        QFilter f1 = new QFilter("number", "=", (Object)"zsse");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist_trees", (String)"id", (QFilter[])new QFilter[]{f1});
        if (null == dynamicObject) {
            return;
        }
        Date month = data.getData().getDate("month");
        QFilter groupid = new QFilter("group", "=", (Object)dynamicObject.getLong("id"));
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)month));
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)month)).or(QFilter.isNull((String)"entryentity.enddate"));
        QFilter fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tpo_tcvat_assist", (String)"name,number,entryentity.fvalue1 as fvalue1", (QFilter[])new QFilter[]{groupid, startdate, enddate, fstatus1});
        JSONArray entryentity = data.getData().getJSONArray("entryentity");
        if (entryentity != null) {
            for (Object entry : entryentity) {
                JSONObject obj = (JSONObject)entry;
                int result = Integer.parseInt(obj.getString("cbfbs"));
                if (16 <= result) {
                    this.setValue(data, coll, "zsse-006", message, obj);
                    continue;
                }
                if (13 <= result) {
                    this.setValue(data, coll, "zsse-005", message, obj);
                    continue;
                }
                if (10 <= result) {
                    this.setValue(data, coll, "zsse-004", message, obj);
                    continue;
                }
                if (7 <= result) {
                    this.setValue(data, coll, "zsse-003", message, obj);
                    continue;
                }
                if (4 <= result) {
                    this.setValue(data, coll, "zsse-002", message, obj);
                    continue;
                }
                if (1 > result) continue;
                this.setValue(data, coll, "zsse-001", message, obj);
            }
        }
    }

    private void setValue(ImportBillData data, DynamicObjectCollection coll, String number, StringBuilder message, JSONObject entryItem) {
        if (coll.size() == 0) {
            message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd %1$s \u4e0d\u5728\u201c\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4>\u5176\u4ed6\u7a0e\u8d39>\u73af\u4fdd\u7a0e>\u7a0e\u52a1\u8f85\u52a9\u6570\u636e\u201d \u4e2d\u7f16\u7801\u4e3a%1$s\u7a0e\u6b3e\u7684\u6709\u6548\u671f\u5185\u3002", (String)"NoiseInfoImportPlugin_12", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), data.getData().getString("month"), number));
            return;
        }
        Optional<DynamicObject> assist = coll.stream().filter(c -> number.equals(c.getString("number"))).findFirst();
        if (assist.isPresent()) {
            DynamicObject object = assist.get();
            if (StringUtils.isBlank((CharSequence)object.getString("fvalue1"))) {
                message.append(String.format(ResManager.loadKDString((String)"\u5355\u4f4d\u7a0e\u989d\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u201c\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4>\u5176\u4ed6\u7a0e\u8d39>\u73af\u4fdd\u7a0e>\u7a0e\u52a1\u8f85\u52a9\u6570\u636e\u201d \u4e2d\u7ef4\u62a4\u7f16\u7801\u4e3a%s\u8bb0\u5f55\u7684\u5355\u4f4d\u7a0e\u989d\u503c\u3002", (String)"NoiseInfoImportPlugin_13", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), data.getData().getString("month"), number));
                return;
            }
            BigDecimal dwse = new BigDecimal(object.getString("fvalue1"));
            BigDecimal jsyj = entryItem.get((Object)"jsyj") == null ? BigDecimal.ZERO : (BigDecimal)entryItem.get((Object)"jsyj");
            BigDecimal ynse = jsyj.multiply(dwse).setScale(2, RoundingMode.HALF_UP);
            BigDecimal bqyjse = new BigDecimal(entryItem.get((Object)"bqyjse") == null ? "0" : entryItem.getString("bqyjse"));
            BigDecimal bqybtse = ynse.subtract(bqyjse);
            entryItem.put("sm", (Object)object.getString("name"));
            entryItem.put("dwse", (Object)dwse);
            entryItem.put("ynse", (Object)ynse);
            entryItem.put("bqybtse", (Object)bqybtse);
        }
    }

    public static DynamicObject loadTaxMain(String orgNumber) {
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject taxMain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,orgid", (QFilter[])new QFilter[]{orgFilter});
        return taxMain;
    }
}

