/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.constant.PollutionBaseDataConstant;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PollutionBaseDataUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class PollutionBaseDataSaveValidator
extends AbstractValidator
implements PollutionBaseDataConstant {
    private static Log LOGGER = LogFactory.getLog(PollutionBaseDataSaveValidator.class);
    private Map<String, DynamicObject> map = new HashMap<String, DynamicObject>();

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.repeatValid(dataEntity);
            this.locationValid(dataEntity);
            this.timeValid(dataEntity);
            this.hasBasicValid(dataEntity);
            this.swrlValid(dataEntity);
            this.wrwlbValid(dataEntity);
            this.wrwmcValid(dataEntity);
            this.pwxkzbhValid(dataEntity);
            this.jsffValid(dataEntity);
            this.saveWrwname(dataEntity);
        }
    }

    private void locationValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        int jingdu = currentObj.getInt("jingdu");
        int jingdufen = currentObj.getInt("jingdufen");
        BigDecimal jingdumiao = currentObj.getBigDecimal("jingdumiao");
        int weidu = currentObj.getInt("weidu");
        int weidufen = currentObj.getInt("weidufen");
        BigDecimal weidumiao = currentObj.getBigDecimal("weidumiao");
        if (jingdu < 0 || jingdu > 180) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7ecf\u5ea6-\u5ea6\u201d\u9700\u8981\u5f55\u5165[0-180]\u5185\u7684\u6574\u6570\u3002", (String)"PollutionBaseDataSaveValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (weidu < 0 || weidu > 90) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7eac\u5ea6-\u5ea6\u8bf7\u5f55\u5165[0-90]\u5185\u7684\u6574\u6570\u3002", (String)"PollutionBaseDataSaveValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (jingdufen < 0 || jingdufen > 60 || weidufen < 0 || weidufen > 60) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5ea6-\u5206or\u7eac\u5ea6-\u5206\u8bf7\u5f55\u5165[0-60]\u5185\u7684\u6574\u6570", (String)"PollutionBaseDataSaveValidator_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        boolean b1 = jingdumiao != null && (jingdumiao.doubleValue() < 0.0 || jingdumiao.doubleValue() > 60.0);
        boolean b2 = weidumiao != null && (weidumiao.doubleValue() < 0.0 || weidumiao.doubleValue() > 60.0);
        LOGGER.info(ResManager.loadKDString((String)"\u7ecf\u7eac\u5ea6\u6570\u636e\uff0cid:{},jingdumiao:{},weidumiao:{}", (String)"PollutionBaseDataSaveValidator_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), new Object[]{currentObj.get("id"), jingdumiao, weidumiao});
        if (b1 || b2) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ecf\u5ea6-\u79d2or\u7eac\u5ea6-\u79d2\u8bf7\u5f55\u5165[0.0-60.0]\u5185\u7684\u5c0f\u6570\uff0c\u4fdd\u75591\u4f4d\u5c0f\u6570", (String)"PollutionBaseDataSaveValidator_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void saveWrwname(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        if ("405".equals(wrwmcNumber)) {
            currentObj.set("wrwname", (Object)currentObj.getString("cpwxsdwrwmc"));
        } else if ("406".equals(wrwmcNumber)) {
            currentObj.set("wrwname", (Object)currentObj.getString("cycsdwrwmc"));
        } else if ("407".equals(wrwmcNumber)) {
            currentObj.set("wrwname", (Object)currentObj.getString("hygcpfwrwmc"));
        } else if ("40404".equals(wrwmcNumber) && StringUtil.isNotEmpty((CharSequence)currentObj.getString("qtgtfw"))) {
            currentObj.set("wrwname", (Object)currentObj.getString("qtgtfw"));
        } else {
            currentObj.set("wrwname", (Object)this.getF7FieldName(currentObj, "wrwmc"));
        }
    }

    private void jsffValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        String wrwpfljsffNumber = this.getF7FieldNum(currentObj, "wrwpfljsff");
        if ("206".equals(wrwpfljsffNumber) && !"104".equals(wrwlbNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709104\u56fa\u4f53\u5e9f\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u7f16\u7801\u4e3a206", (String)"PollutionBaseDataSaveValidator_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void pwxkzbhValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        DynamicObject org = currentObj.getDynamicObject("org");
        String pwxkznumNumber = this.getF7FieldNum(currentObj, "pwxkznum");
        if (StringUtil.isEmpty((CharSequence)pwxkznumNumber)) {
            return;
        }
        DynamicObjectCollection hbsEntity = PollutionBaseDataUtils.getHbsEntity((Long)org.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)hbsEntity) || hbsEntity.stream().noneMatch(s -> pwxkznumNumber.equals(s.getString("hjbhs_number")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u7a0e\u79cd\u5361\u7247\u6ca1\u6709\u8be5\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7", (String)"PollutionBaseDataSaveValidator_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void wrwmcValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        DynamicObject org = currentObj.getDynamicObject("org");
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        String wrwpfljsffNumber = this.getF7FieldNum(currentObj, "wrwpfljsff");
        String cpwxsdwrwmc = currentObj.getString("cpwxsdwrwmc");
        String cycsdwrwmc = currentObj.getString("cycsdwrwmc");
        String hygcpfwrwmc = currentObj.getString("hygcpfwrwmc");
        if ("407".equals(wrwmcNumber)) {
            Predicate<DynamicObject> predicate = s -> Boolean.TRUE.equals(s.getBoolean("hjbhs_cshygc"));
            Boolean ishaiyang = PollutionBaseDataUtils.validHbsEntityBaseData((Long)org.getLong("id"), predicate);
            if (!ishaiyang.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\uff0c\u5728\u7a0e\u79cd\u5361\u7247\u201c\u73af\u5883\u4fdd\u62a4\u7a0e\u201d\u4e2d\u786e\u5b9a\u8be5\u7ec4\u7ec7\u662f\u5426\u4ece\u4e8b\u6d77\u6d0b\u5de5\u7a0b\u3002", (String)"PollutionBaseDataSaveValidator_7", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            } else if (!Lists.newArrayList((Object[])new String[]{"101", "102"}).contains(wrwlbNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u786e\u8ba4\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u79cd\u7c7b\u53ca\u6c61\u67d3\u7269\u540d\u79f0", (String)"PollutionBaseDataSaveValidator_8", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (StringUtil.isBlank((CharSequence)hygcpfwrwmc)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u6d77\u6d0b\u5de5\u7a0b\u4ea7\u751f\u7684\u6c34\u6c61\u67d3\u7269\u6216\u5927\u6c14\u6c61\u67d3\u7269\u201d\uff0c\u8bf7\u586b\u5199\u201c\u6d77\u6d0b\u5de5\u7a0b\u6392\u653e\u6c61\u67d3\u7269\u540d\u79f0\u201d\u5217", (String)"PollutionBaseDataSaveValidator_9", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        } else if (StringUtil.isNotBlank((CharSequence)hygcpfwrwmc)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u6d77\u6d0b\u5de5\u7a0b\u4ea7\u751f\u7684\u6c34\u6c61\u67d3\u7269\u6216\u5927\u6c14\u6c61\u67d3\u7269\u201d\uff0c\u624d\u9700\u8981\u586b\u5199\u201c\u6d77\u6d0b\u5de5\u7a0b\u6392\u653e\u6c61\u67d3\u7269\u540d\u79f0\u201d", (String)"PollutionBaseDataSaveValidator_10", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (!"40404".equals(wrwmcNumber) && StringUtil.isNotBlank((CharSequence)currentObj.getString("qtgtfw"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u4e3a\u201c\u51b6\u70bc\u6e23\u3001\u7c89\u7164\u78b3\u3001\u7089\u6e23\u3001\u5176\u4ed6\u56fa\u4f53\u5e9f\u7269\uff08\u542b\u534a\u56fa\u6001\u3001\u6db2\u6001\u5e9f\u7269\uff09\u201d\u65f6\uff0c\u65e0\u9700\u586b\u5199\u201c\u5176\u4ed6\u56fa\u4f53\u5e9f\u7269\u201d\u5217", (String)"PollutionBaseDataSaveValidator_11", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        } else if ("40404".equals(wrwmcNumber) && StringUtil.isBlank((CharSequence)currentObj.getString("qtgtfw"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5176\u4ed6\u56fa\u4f53\u5e9f\u7269\u201d\u7684\u503c\u3002", (String)"PollutionBaseDataSaveValidator_12", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (!"405".equals(wrwmcNumber)) {
            if (StringUtil.isNotBlank((CharSequence)cpwxsdwrwmc)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u9002\u7528\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u201d\uff0c\u624d\u9700\u8981\u586b\u5199\u201c\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u540d\u79f0\u201d", (String)"PollutionBaseDataSaveValidator_13", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (StringUtil.isBlank((CharSequence)cpwxsdwrwmc)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u9002\u7528\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u201d\uff0c\u8bf7\u586b\u5199\u201c\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u540d\u79f0\u201d\u5217", (String)"PollutionBaseDataSaveValidator_14", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!"203".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9002\u7528\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e3a203\u4ea7\u6392\u6c61\u7cfb\u6570\uff0c\u8bf7\u786e\u5b9a\u5f55\u5165\u4fe1\u606f", (String)"PollutionBaseDataSaveValidator_15", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
        if (!"406".equals(wrwmcNumber)) {
            if (StringUtil.isNotBlank((CharSequence)cycsdwrwmc)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u9002\u7528\u62bd\u6837\u6d4b\u7b97\u7684\u6c61\u67d3\u7269\u201d\uff0c\u624d\u9700\u8981\u586b\u5199\u201c\u62bd\u6837\u6d4b\u7b97\u7684\u6c61\u67d3\u7269\u540d\u79f0\u201d", (String)"PollutionBaseDataSaveValidator_16", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (StringUtil.isBlank((CharSequence)cycsdwrwmc)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0\u4e3a\u201c\u9002\u7528\u62bd\u6837\u6d4b\u7b97\u7684\u6c61\u67d3\u7269\u201d\uff0c\u8bf7\u586b\u5199\u201c\u62bd\u6837\u6d4b\u7b97\u7684\u6c61\u67d3\u7269\u540d\u79f0\u201d\u5217", (String)"PollutionBaseDataSaveValidator_17", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!"205".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9002\u7528\u62bd\u6837\u6d4b\u7b97\u7684\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e3a205\u62bd\u6837\u6d4b\u7b97\uff0c\u8bf7\u786e\u5b9a\u5f55\u5165\u4fe1\u606f", (String)"PollutionBaseDataSaveValidator_18", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
        if ("40403".equals(wrwmcNumber) && StringUtil.isBlank((CharSequence)currentObj.getString("zszm"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u4e3a\u5371\u9669\u5e9f\u7269\u65f6\uff0c\u8bf7\u5f55\u5165\u5177\u4f53\u7684\u5f81\u6536\u5b50\u76ee\u3002", (String)"PollutionBaseDataSaveValidator_19", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if ("408".equals(wrwmcNumber) && !"103".equals(wrwlbNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u566a\u58f0\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u540d\u79f0\u7f16\u7801\u4e3a408", (String)"PollutionBaseDataSaveValidator_20", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void wrwlbValid(ExtendedDataEntity dataEntity) {
        List numbers;
        DynamicObject currentObj = dataEntity.getDataEntity();
        String swrwzlNumber = this.getF7FieldNum(currentObj, "swrwzl");
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        String wrwmcNumber = this.getF7FieldNum(currentObj, "wrwmc");
        String wrwpfljsffNumber = this.getF7FieldNum(currentObj, "wrwpfljsff");
        if ("101".equals(wrwlbNumber)) {
            numbers = PollutionBaseDataUtils.getNumber((String)wrwlbNumber, (String)swrwzlNumber);
            if ("301".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u7b2c\u4e00\u7c7b\u6c34\u6c61\u67d3\u7269", (String)"PollutionBaseDataSaveValidator_21", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ("302".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u7b2c\u4e8c\u7c7b\u6c34\u6c61\u67d3\u7269", (String)"PollutionBaseDataSaveValidator_22", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ("303".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5217\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8ePH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269", (String)"PollutionBaseDataSaveValidator_23", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ("304".equals(swrwzlNumber) && !numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a", (String)"PollutionBaseDataSaveValidator_24", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ("304".equals(swrwzlNumber) && !"205".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u79cd\u7c7b\u4ec5\u9002\u7528\u62bd\u6837\u6d4b\u7b97\u8ba1\u7b97\u65b9\u6cd5\uff0c\u8bf7\u786e\u5b9a\u5f55\u5165\u4fe1\u606f", (String)"PollutionBaseDataSaveValidator_25", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
        if ("102".equals(wrwlbNumber) && !(numbers = PollutionBaseDataUtils.getNumber((String)wrwlbNumber, (String)"")).contains(wrwmcNumber)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u5927\u6c14\u6c61\u67d3\u7269", (String)"PollutionBaseDataSaveValidator_26", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if ("103".equals(wrwlbNumber)) {
            if (!"408".equals(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u566a\u58f0\u6c61\u67d3\u7269\u7684\u6c61\u67d3\u7269\u540d\u79f0\u7f16\u7801\u4e3a408", (String)"PollutionBaseDataSaveValidator_27", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!Lists.newArrayList((Object[])new String[]{"201", "202"}).contains(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u566a\u58f0\u4ec5\u9002\u7528\u201c\u81ea\u52a8\u76d1\u6d4b\u201d\u6216\u201c\u76d1\u6d4b\u673a\u6784\u76d1\u6d4b\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PollutionBaseDataSaveValidator_28", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
        if ("104".equals(wrwlbNumber)) {
            numbers = PollutionBaseDataUtils.getNumber((String)wrwlbNumber, (String)"");
            if (!numbers.contains(wrwmcNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5c5e\u4e8e\u56fa\u4f53\u5e9f\u7269", (String)"PollutionBaseDataSaveValidator_29", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!"206".equals(wrwpfljsffNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fa\u4f53\u5e9f\u7269\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u7f16\u7801\u4e3a206", (String)"PollutionBaseDataSaveValidator_30", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void swrlValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        String swrwzlNumber = this.getF7FieldNum(currentObj, "swrwzl");
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        if (StringUtil.isEmpty((CharSequence)swrwzlNumber)) {
            if ("101".equals(wrwlbNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u6c61\u67d3\u7269\u7c7b\u522b\u662f\u6c34\u6c61\u67d3\u7269\u65f6\uff0c\u5fc5\u987b\u5f55\u5165\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataSaveValidator_31", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (!Lists.newArrayList((Object[])new String[]{"301", "302", "303", "304"}).contains(swrwzlNumber)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u7f16\u7801\uff1a%s", (String)"PollutionBaseDataSaveValidator_32", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), swrwzlNumber));
            }
            if (!"101".equals(wrwlbNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u79cd\u7c7b\u4e0d\u662f\u6c34\u6c61\u67d3\u7269\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"PollutionBaseDataSaveValidator_33", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getF7FieldNum(DynamicObject currentObj, String field) {
        DynamicObject dynamicObject = currentObj.getDynamicObject(field);
        return dynamicObject != null ? dynamicObject.getString("number") : "";
    }

    private String getF7FieldName(DynamicObject currentObj, String field) {
        DynamicObject dynamicObject = currentObj.getDynamicObject(field);
        return dynamicObject != null ? dynamicObject.getString("name") : "";
    }

    private void hasBasicValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        String wrwlbNumber = this.getF7FieldNum(currentObj, "wrwlb");
        QFilter orgFilter = new QFilter("org.number", "=", (Object)this.getF7FieldNum(currentObj, "org"));
        DynamicObject org = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org.id as id,org.number as number", (QFilter[])new QFilter[]{orgFilter});
        QFilter q3 = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"WRWZL"}));
        QFilter q4 = new QFilter("entry_detail.subnumber", "=", (Object)wrwlbNumber);
        DynamicObject wrwlbObj = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef", (String)"entry_detail.id,entry_detail.subnumber,entry_detail.projectname", (QFilter[])new QFilter[]{q3, q4});
        if (Lists.newArrayList((Object[])new String[]{"101", "102", "103", "104"}).contains(wrwlbNumber) && wrwlbObj != null) {
            Predicate<DynamicObject> predicate = s -> Arrays.stream(s.getString("hjbhs_pollutanttype").split(",")).collect(Collectors.toList()).contains(wrwlbNumber);
            if (!PollutionBaseDataUtils.validHbsEntityBaseData((Long)org.getLong("id"), predicate).booleanValue()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u672a\u5305\u542b%s", (String)"PollutionBaseDataSaveValidator_34", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), wrwlbObj.getString("entry_detail.projectname")));
            }
        } else {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u7f16\u7801\uff1a%s", (String)"PollutionBaseDataSaveValidator_35", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), wrwlbNumber));
        }
    }

    private void timeValid(ExtendedDataEntity dataEntity) {
        int dayOfDate2;
        int dayOfDate1;
        DynamicObject currentObj = dataEntity.getDataEntity();
        Date startdate = currentObj.getDate("startdate");
        Date enddate = currentObj.getDate("enddate");
        if (startdate == null || enddate == null) {
            return;
        }
        int dayOfDate = DateUtils.getDayOfDate((Date)startdate);
        if (dayOfDate != 1) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d1\u53f7\u3002", (String)"PollutionBaseDataSaveValidator_36", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if ((dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate))) != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"PollutionBaseDataSaveValidator_37", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        if (startdate.after(enddate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6e90\u6709\u6548\u671f\u6b62\u7684\u65f6\u95f4\u5e94\u665a\u4e8e\u7a0e\u6e90\u6709\u6548\u671f\u8d77\u7684\u65f6\u95f4\u3002", (String)"PollutionBaseDataSaveValidator_38", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void repeatValid(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        Long pkValue = (Long)currentObj.getPkValue();
        String orgNum = this.getF7FieldNum(currentObj, "org");
        String number = currentObj.getString("number");
        String wrwlb = this.getF7FieldNum(currentObj, "wrwlb");
        String swrwzl = this.getF7FieldNum(currentObj, "swrwzl");
        String wrwmcNum = this.getF7FieldNum(currentObj, "wrwmc");
        Date startDate = currentObj.getDate("startdate");
        Date endDate = currentObj.getDate("enddate");
        String key = String.format("%s_%s_%s_%s_%s_%s_%s", orgNum, number, wrwlb, swrwzl, wrwmcNum, startDate, endDate);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(Arrays.asList(new QFilter("org.number", "=", (Object)orgNum), new QFilter("number", "=", (Object)number), new QFilter("wrwlb.number", "=", (Object)wrwlb), new QFilter("wrwmc.number", "=", (Object)wrwmcNum), new QFilter("startdate", "<=", (Object)startDate).and(new QFilter("enddate", ">", (Object)startDate)).or(new QFilter("startdate", "<", (Object)endDate).and(new QFilter("enddate", ">=", (Object)endDate))).or(new QFilter("startdate", ">=", (Object)startDate).and(new QFilter("enddate", "<=", (Object)endDate))).or(new QFilter("startdate", "<=", (Object)startDate).and(new QFilter("enddate", ">=", (Object)endDate))), new QFilter("id", "!=", (Object)pkValue)));
        if (StringUtil.isNotEmpty((CharSequence)swrwzl)) {
            qFilters.add(new QFilter("swrwzl.number", "=", (Object)swrwzl));
        }
        if ("405".equals(wrwmcNum)) {
            String otherWrwmc = currentObj.getString("cpwxsdwrwmc");
            qFilters.add(new QFilter("cpwxsdwrwmc", "=", (Object)otherWrwmc));
            key = String.format(key + "_%s", otherWrwmc);
        } else if ("406".equals(wrwmcNum)) {
            String otherWrwmc = currentObj.getString("cycsdwrwmc");
            qFilters.add(new QFilter("cycsdwrwmc", "=", (Object)otherWrwmc));
            key = String.format(key + "_%s", otherWrwmc);
        } else if ("407".equals(wrwmcNum)) {
            String otherWrwmc = currentObj.getString("hygcpfwrwmc");
            qFilters.add(new QFilter("hygcpfwrwmc", "=", (Object)otherWrwmc));
            key = String.format(key + "_%s", otherWrwmc);
        } else if ("40404".equals(wrwmcNum)) {
            String otherWrwmc = currentObj.getString("qtgtfw");
            qFilters.add(new QFilter("qtgtfw", "=", (Object)otherWrwmc));
            key = String.format(key + "_%s", otherWrwmc);
        }
        if (this.map.containsKey(key)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"PollutionBaseDataSaveValidator_39", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        } else {
            this.map.put(key, currentObj);
        }
        if (QueryServiceHelper.exists((String)"tdm_pollution_basedata", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"PollutionBaseDataSaveValidator_39", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }
}

