/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tdm.opplugin.ImportDateCheckParams;

public class ProApportionDetailImportValidator
extends AbstractValidator {
    public void validate() {
        List<ImportDateCheckParams> dateList;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)true);
        boolean isAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List hasPermOrgIds = null;
        if (!isAllOrgPerm) {
            hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        }
        HashSet<Long> taxOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> costCenterSet = new HashSet<Long>(16);
        HashSet<Long> shareTypeSet = new HashSet<Long>(16);
        HashSet<Long> devProjectIdSet = new HashSet<Long>(16);
        HashMap dateMap = new HashMap(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject taxOrg = info.getDynamicObject("taxorg");
            long taxOrgId = taxOrg.getLong("id");
            if (isAllOrgPerm) {
                taxOrgIdSet.add(taxOrgId);
            } else if (hasPermOrgIds != null && hasPermOrgIds.contains(taxOrgId)) {
                taxOrgIdSet.add(taxOrgId);
            }
            long devProjectId = info.getDynamicObject("devproject").getLong("id");
            devProjectIdSet.add(devProjectId);
            DynamicObject costcenter = info.getDynamicObject("costcenter");
            long costCenterId = 0L;
            if (costcenter != null) {
                costCenterId = costcenter.getLong("id");
            }
            costCenterSet.add(costCenterId);
            long shareTypeId = info.getDynamicObject("sharetype").getLong("id");
            shareTypeSet.add(shareTypeId);
            ImportDateCheckParams checkParams = new ImportDateCheckParams(info.getLong("id"), info.getDate("startdate"), info.getDate("enddate"));
            String key = taxOrgId + "_" + devProjectId + "_" + costCenterId + "_" + shareTypeId;
            dateList = new ArrayList();
            if (dateMap.containsKey(key)) {
                dateList = (List)dateMap.get(key);
            }
            dateList.add(checkParams);
            dateMap.put(key, dateList);
        }
        QFilter filter = new QFilter("taxorg", "in", taxOrgIdSet);
        filter.and("devproject", "in", devProjectIdSet);
        filter.and("costcenter", "in", costCenterSet);
        filter.and("sharetype", "in", shareTypeSet);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tdm_pro_apportion_detail", (String)"id,taxorg,devproject,costcenter,sharetype,startdate,enddate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject col : cols) {
            String key = col.getLong("taxorg") + "_" + col.getLong("devproject") + "_" + col.getString("costcenter") + "_" + col.getLong("sharetype");
            ImportDateCheckParams dateCheck = new ImportDateCheckParams(col.getLong("id"), col.getDate("startdate"), col.getDate("enddate"));
            dateList = new ArrayList<ImportDateCheckParams>();
            if (dateMap.containsKey(key)) {
                dateList = (List)dateMap.get(key);
            }
            dateList.add(dateCheck);
            dateMap.put(key, dateList);
        }
        HashSet<Long> rightTaxOrgSet = new HashSet<Long>(16);
        HashSet<Long> yfxmIdSet = new HashSet<Long>(16);
        HashSet<Long> enableCostIdSet = new HashSet<Long>(16);
        HashSet<Long> enableShareTypeSet = new HashSet<Long>(16);
        QFilter taxOrgFilter = new QFilter("id", "in", taxOrgIdSet);
        taxOrgFilter.and("istaxpayer", "=", (Object)Boolean.TRUE);
        taxOrgFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection taxOrgData = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{taxOrgFilter});
        for (DynamicObject row : taxOrgData) {
            rightTaxOrgSet.add(row.getLong("org"));
        }
        QFilter yfxmFilter = new QFilter("org", "in", rightTaxOrgSet);
        yfxmFilter.and("status", "=", (Object)"C");
        yfxmFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection yfxmData = QueryServiceHelper.query((String)"rdesd_yfxmxx", (String)"id", (QFilter[])new QFilter[]{yfxmFilter});
        for (DynamicObject row : yfxmData) {
            yfxmIdSet.add(row.getLong("id"));
        }
        QFilter costCenterFilter = new QFilter("id", "in", costCenterSet);
        costCenterFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection costCenterData = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{costCenterFilter});
        for (DynamicObject row : costCenterData) {
            enableCostIdSet.add(row.getLong("id"));
        }
        QFilter shareTypeFilter = new QFilter("id", "in", shareTypeSet);
        shareTypeFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection shareTypeData = QueryServiceHelper.query((String)"rdesd_share_type", (String)"id", (QFilter[])new QFilter[]{shareTypeFilter});
        for (DynamicObject row : shareTypeData) {
            enableShareTypeSet.add(row.getLong("id"));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject shareType;
            long shareTypeId;
            DynamicObject devProject;
            long devProjectId;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject taxOrg = info.getDynamicObject("taxorg");
            long taxOrgId = taxOrg.getLong("id");
            if (!rightTaxOrgSet.contains(taxOrgId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ProApportionDetailImportValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            Date startDate = info.getDate("startdate");
            Calendar startCa = Calendar.getInstance();
            startCa.setTime(startDate);
            int startYear = startCa.get(1);
            int startMonth = startCa.get(2);
            Date endDate = info.getDate("enddate");
            Calendar endCa = Calendar.getInstance();
            endCa.setTime(endDate);
            int endYear = endCa.get(1);
            int endMonth = endCa.get(2);
            if (startDate.compareTo(endDate) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff1b", (String)"ProApportionDetailImportValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (startYear != endYear || startMonth != endMonth) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u8de8\u6708\uff1b", (String)"ProApportionDetailImportValidator_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!yfxmIdSet.contains(devProjectId = (devProject = info.getDynamicObject("devproject")).getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7814\u53d1\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ProApportionDetailImportValidator_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObject costCenter = info.getDynamicObject("costcenter");
            long costCenterId = 0L;
            if (costCenter != null && !enableCostIdSet.contains(costCenterId = costCenter.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ProApportionDetailImportValidator_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!enableShareTypeSet.contains(shareTypeId = (shareType = info.getDynamicObject("sharetype")).getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ProApportionDetailImportValidator_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            boolean exists = false;
            String key = taxOrgId + "_" + devProjectId + "_" + costCenterId + "_" + shareTypeId;
            List dateChecks = (List)dateMap.get(key);
            long billId = info.getLong("id");
            for (ImportDateCheckParams dateCheck : dateChecks) {
                if (billId == dateCheck.getBillId() || !this.hasOverlap(info.getDate("startdate"), info.getDate("enddate"), dateCheck.getStartDate(), dateCheck.getEndDate())) continue;
                exists = true;
                break;
            }
            if (exists) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5728\u7814\u53d1\u9879\u76ee\u7f16\u7801\u5f55\u5165\u7684\u6743\u91cd\u8bb0\u5f55\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"ProApportionDetailImportValidator_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            info.set("datasource", (Object)ResManager.loadKDString((String)"\u6a21\u677f\u5f15\u5165", (String)"ProApportionDetailImportValidator_7", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean hasOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }
}

