/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class RdApportionPaySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("taxorg");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("costtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                Long currUserId = RequestContext.get().getCurrUserId();
                TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)currUserId);
                List data = (List)listTaxResult.getData();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject costType;
                    DynamicObject project;
                    Date startDate;
                    DynamicObject info = dataEntity.getDataEntity();
                    DynamicObject taxOrg = info.getDynamicObject("taxorg");
                    if (!(taxOrg == null || data != null && data.contains(taxOrg.getLong("id")))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdApportionPaySaveOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                    }
                    if ((startDate = info.getDate("startdate")) != null) {
                        Calendar startCa = Calendar.getInstance();
                        startCa.setTime(startDate);
                        int startDay = startCa.get(5);
                        if (startDay != 1) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u53ea\u80fd\u9009\u62e9\u6bcf\u67081\u65e5\uff1b", (String)"RdApportionPaySaveOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if ((project = info.getDynamicObject("project")) != null && taxOrg != null) {
                        QFilter projectFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)taxOrg.getLong("id"));
                        DynamicObjectCollection projectDys = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{projectFilter});
                        HashSet<Long> projectIdSet = new HashSet<Long>(16);
                        for (DynamicObject row : projectDys) {
                            projectIdSet.add(row.getLong("id"));
                        }
                        long id = project.getLong("id");
                        boolean enable = project.getBoolean("enable");
                        String status = project.getString("status");
                        if (!(projectIdSet.contains(id) && enable && "C".equals(status))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdApportionPaySaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if ((costType = info.getDynamicObject("costtype")) == null || costType.getBoolean("enable")) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\u7684\u7814\u53d1\u4eba\u5458\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdApportionPaySaveOp_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

