/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tdm.opplugin.ImportDateCheckParams;

public class RdWorkHoursDetailImportValidator
extends AbstractValidator {
    public void validate() {
        List<ImportDateCheckParams> dateList;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)true);
        boolean isAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List hasPermOrgIds = null;
        if (!isAllOrgPerm) {
            hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        }
        HashMap<String, List<ImportDateCheckParams>> dateMap = new HashMap<String, List<ImportDateCheckParams>>(16);
        HashSet<Long> taxOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> costCenterSet = new HashSet<Long>(16);
        HashSet<Long> devProjectIdSet = new HashSet<Long>(16);
        HashSet<String> personNoSet = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject taxOrg = info.getDynamicObject("taxorg");
            long taxOrgId = taxOrg.getLong("id");
            if (isAllOrgPerm) {
                taxOrgIdSet.add(taxOrgId);
            } else if (hasPermOrgIds != null && hasPermOrgIds.contains(taxOrgId)) {
                taxOrgIdSet.add(taxOrgId);
            }
            DynamicObject costCenter = info.getDynamicObject("costcenter");
            if (costCenter != null) {
                costCenterSet.add(costCenter.getLong("id"));
            }
            devProjectIdSet.add(info.getDynamicObject("devproject").getLong("id"));
            personNoSet.add(info.getString("personno"));
            String key = info.getDynamicObject("taxorg").getLong("id") + "_" + info.getDynamicObject("devproject").getLong("id") + "_" + info.getString("personno");
            ImportDateCheckParams value = new ImportDateCheckParams(info.getLong("id"), info.getDate("startdate"), info.getDate("enddate"));
            dateList = new ArrayList();
            if (dateMap.containsKey(key)) {
                dateList = (List)dateMap.get(key);
            }
            dateList.add(value);
            dateMap.put(key, dateList);
        }
        QFilter filter = new QFilter("taxorg", "in", taxOrgIdSet);
        filter.and("devproject", "in", devProjectIdSet);
        filter.and("personno", "in", personNoSet);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tdm_rd_workhours_detail", (String)"id, taxorg, devproject, personno, startdate, enddate", (QFilter[])filter.toArray());
        for (DynamicObject col : cols) {
            String key = col.getLong("taxorg") + "_" + col.getLong("devproject") + "_" + col.getString("personno");
            ImportDateCheckParams dateCheck = new ImportDateCheckParams(col.getLong("id"), col.getDate("startdate"), col.getDate("enddate"));
            dateList = new ArrayList<ImportDateCheckParams>();
            if (dateMap.containsKey(key)) {
                dateList = (List)dateMap.get(key);
            }
            dateList.add(dateCheck);
            dateMap.put(key, dateList);
        }
        Set<Long> rightTaxOrgSet = this.checkTaxOrg(taxOrgIdSet);
        Set<Long> yfxmIdSet = this.checkYFXM(rightTaxOrgSet);
        Set<Long> enableCostIdSet = this.checkCostCenter(costCenterSet);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date endDate;
            Date startDate;
            DynamicObject devProject;
            long devProjectId;
            DynamicObject costCenter;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject taxOrg = info.getDynamicObject("taxorg");
            long taxOrgId = taxOrg.getLong("id");
            if (!rightTaxOrgSet.contains(taxOrgId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdWorkHoursDetailImportValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ((costCenter = info.getDynamicObject("costcenter")) != null && !enableCostIdSet.contains(costCenter.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdWorkHoursDetailImportValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (!yfxmIdSet.contains(devProjectId = (devProject = info.getDynamicObject("devproject")).getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7814\u53d1\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdWorkHoursDetailImportValidator_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if ((startDate = info.getDate("startdate")).compareTo(endDate = info.getDate("enddate")) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff1b", (String)"RdWorkHoursDetailImportValidator_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (this.checkIsOverMonth(startDate, endDate).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u8de8\u6708\uff1b", (String)"RdWorkHoursDetailImportValidator_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            if (this.checkIsDateOverlap(info, dateMap).booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458\u5de5\u53f7\u5728\u7814\u53d1\u9879\u76ee\u7f16\u7801\u5f55\u5165\u7684\u5de5\u65f6\u8bb0\u5f55\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"RdWorkHoursDetailImportValidator_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            }
            info.set("datasource", (Object)ResManager.loadKDString((String)"\u6a21\u677f\u5f15\u5165", (String)"RdWorkHoursDetailImportValidator_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> checkTaxOrg(Set<Long> taxOrgIdSet) {
        QFilter taxOrgFilter = new QFilter("id", "in", taxOrgIdSet);
        taxOrgFilter.and("istaxpayer", "=", (Object)Boolean.TRUE);
        taxOrgFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org", (QFilter[])taxOrgFilter.toArray());
        return cols.stream().map(col -> col.getLong("org")).collect(Collectors.toSet());
    }

    private Set<Long> checkYFXM(Set<Long> rightTaxOrgSet) {
        QFilter filter = new QFilter("org", "in", rightTaxOrgSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"rdesd_yfxmxx", (String)"id", (QFilter[])filter.toArray());
        return cols.stream().map(col -> col.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> checkCostCenter(Set<Long> costCenterSet) {
        QFilter filter = new QFilter("id", "in", costCenterSet);
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filter.toArray());
        return cols.stream().map(col -> col.getLong("id")).collect(Collectors.toSet());
    }

    private Boolean checkIsOverMonth(Date startDate, Date endDate) {
        Calendar startCa = Calendar.getInstance();
        startCa.setTime(startDate);
        int startYear = startCa.get(1);
        int startMonth = startCa.get(2);
        Calendar endCa = Calendar.getInstance();
        endCa.setTime(endDate);
        int endYear = endCa.get(1);
        int endMonth = endCa.get(2);
        return startYear != endYear || startMonth != endMonth;
    }

    private Boolean checkIsDateOverlap(DynamicObject info, Map<String, List<ImportDateCheckParams>> dateMap) {
        long taxOrgId = info.getDynamicObject("taxorg").getLong("id");
        long devProjectId = info.getDynamicObject("devproject").getLong("id");
        String personNo = info.getString("personno");
        long billId = info.getLong("id");
        String key = taxOrgId + "_" + devProjectId + "_" + personNo;
        List<ImportDateCheckParams> dateChecks = dateMap.get(key);
        for (ImportDateCheckParams dateCheck : dateChecks) {
            if (billId == dateCheck.getBillId() || !this.hasOverlap(info.getDate("startdate"), info.getDate("enddate"), dateCheck.getStartDate(), dateCheck.getEndDate())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean hasOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }
}

