/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.entity.CheckTimeDTO;
import kd.taxc.tdm.common.util.CheckTimeRepeatUtils;
import kd.taxc.tdm.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxSourceInfoSaveValidator
extends AbstractValidator {
    public static final String ENTRYENTITY = "entryentity";
    public static final String STARTDATE = "start";
    public static final String ENDDATE = "end";
    private String orgField;

    public TaxSourceInfoSaveValidator(String orgField) {
        this.orgField = orgField;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            CheckTimeDTO checkTimeDTO;
            DynamicObject currentObj = dataEntity.getDataEntity();
            DynamicObject org = currentObj.getDynamicObject(this.orgField);
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TaxSourceInfoSaveValidator_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntitys = currentObj.getDynamicObjectCollection(ENTRYENTITY);
            if (!CollectionUtils.isNotEmpty((Collection)entryEntitys)) continue;
            for (int i = 0; i < entryEntitys.size(); ++i) {
                Date end;
                DynamicObject obj = (DynamicObject)entryEntitys.get(i);
                Date start = obj.getDate(STARTDATE);
                if (start == null) {
                    return;
                }
                if (start != null && DateUtils.getFirstDateOfYear((Date)start).compareTo(start) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u7b2c%s\u884c,\u51cf\u514d\u8d77\u59cb\u65f6\u95f4\u53ea\u80fd\u9009\u62e91\u67081\u65e5\u3002", (String)"TaxSourceInfoSaveValidator_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), i + 1));
                }
                if ((end = obj.getDate(ENDDATE)) != null && DateUtils.getLastDateOfYear((Date)end).compareTo(end) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u7b2c%s\u884c,\u51cf\u514d\u7ec8\u6b62\u65f6\u95f4\u53ea\u80fd\u9009\u62e912\u670831\u65e5\u3002", (String)"TaxSourceInfoSaveValidator_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), i + 1));
                }
                if (end == null || end.after(start)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u767b\u8bb0\u53f0\u8d26\u7b2c%s\u884c,\u51cf\u514d\u8d77\u6b62\u65f6\u95f4\u5f55\u5165\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxSourceInfoSaveValidator_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            if (entryEntitys.size() <= 1 || (checkTimeDTO = CheckTimeRepeatUtils.checkTimeRepeat((DynamicObjectCollection)entryEntitys)).isResult()) continue;
            this.addErrorMessage(dataEntity, checkTimeDTO.getMessqge());
        }
    }
}

