/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class WaterResourceSaveOp
extends AbstractOperationServicePlugIn {
    private static final String QSXKZT_HANDLED = "1";
    private static final String JNQX_AYSB = "aysb";
    private static final String JNQX_AJSB = "ajsb";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    QFilter q7;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    DynamicObject org = dynamicObject.getDynamicObject("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WaterResourceSaveOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject taxsource = dynamicObject.getDynamicObject("taxsource");
                    Date startdate = taxsource.getDate("startdate");
                    Date enddate = taxsource.getDate("enddate");
                    Date skssqq = dynamicObject.getDate("skssqq");
                    Date skssqz = dynamicObject.getDate("skssqz");
                    if (WaterResourceSaveOp.QSXKZT_HANDLED.equals(taxsource.getString("qsxkzt")) && (startdate.compareTo(skssqz) > 0 || enddate.compareTo(skssqq) < 0)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u5728\u53d6\u6c34\u8bb8\u53ef\u8bc1\u6709\u6548\u671f\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceSaveOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String jnqx = taxsource.getString("jnqx");
                    if (skssqq.compareTo(skssqz) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u201d\u5fc5\u987b\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (WaterResourceSaveOp.JNQX_AYSB.equals(jnqx)) {
                        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)skssqq);
                        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)skssqq);
                        if (!StringUtil.equals((CharSequence)DateUtils.format((Date)skssqq), (CharSequence)DateUtils.format((Date)firstDateOfMonth)) || !StringUtil.equals((CharSequence)DateUtils.format((Date)skssqz), (CharSequence)DateUtils.format((Date)lastDateOfMonth))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u201d\u5fc5\u987b\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    } else if (WaterResourceSaveOp.JNQX_AJSB.equals(jnqx)) {
                        Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)skssqq);
                        Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                        if (!StringUtil.equals((CharSequence)DateUtils.format((Date)skssqq), (CharSequence)DateUtils.format((Date)firstDateOfSeason)) || !StringUtil.equals((CharSequence)DateUtils.format((Date)skssqz), (CharSequence)DateUtils.format((Date)lastDateOfSeason))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u201d\u5fc5\u987b\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceSaveOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    QFilter q1 = new QFilter("org", "=", (Object)taxsource.getLong("org_id"));
                    QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq);
                    QFilter q3 = new QFilter("skssqz", "=", (Object)skssqz);
                    QFilter q4 = new QFilter("type", "=", (Object)"szys_a");
                    QFilter q5 = new QFilter("taxauthority", "=", (Object)taxsource.getLong("taxauthority_id"));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
                    List sbbids = collection.stream().map(d -> d.getString("id")).collect(Collectors.toList());
                    QFilter q6 = new QFilter("szybh", "=", (Object)taxsource.getString("number"));
                    boolean exists = QueryServiceHelper.exists((String)"tcwat_declare_a_base", (QFilter[])new QFilter[]{q6, q7 = new QFilter("sbbid", "in", sbbids)});
                    if (exists) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7a0e\u671f\u7684\u7533\u62a5\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WaterResourceSaveOp_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String sysbb = taxsource.getString("sysbb");
                    DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (sysbb.equals("B")) {
                        if (entryentity.size() == 0) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u9002\u7528\u7533\u62a5\u8868\u4e3a\u6c34\u8d44\u6e90\u7a0e\u7eb3\u7a0e\u7533\u62a5\u8868B\u65f6\uff0c\u6c34\u8d44\u6e90\u7eb3\u7a0e\u7533\u62a5\u8868B\u53d6\u6c34\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WaterResourceSaveOp_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        Set zszmids = entryentity.stream().map(p -> p.getString("zszm.id")).collect(Collectors.toSet());
                        if (zszmids.size() != entryentity.size()) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee\u4e0d\u80fd\u91cd\u590d\u3002", (String)"WaterResourceSaveOp_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        dynamicObject.set("sqljqsl", (Object)BigDecimal.ZERO);
                        dynamicObject.set("bqqsl", (Object)BigDecimal.ZERO);
                        continue;
                    }
                    if (!sysbb.equals("A")) continue;
                    entryentity.clear();
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObject taxsource = dynamicObject.getDynamicObject("taxsource");
            Long orgId = taxsource.getLong("org_id");
            dynamicObject.set("org", (Object)taxsource.getDynamicObject("org"));
            String number = taxsource.getString("number");
            Long taxauthorityId = taxsource.getLong("taxauthority_id");
            dynamicObject.set("billno", (Object)number);
            if (!EmptyCheckUtils.isEmpty((Object)dynamicObject.get("sqljqsl"))) continue;
            String jnqx = taxsource.getString("jnqx");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            BigDecimal sqljqsl = this.getSqljqsl(orgId, number, taxauthorityId, jnqx, skssqq, skssqz);
            dynamicObject.set("sqljqsl", (Object)sqljqsl);
        }
    }

    private BigDecimal getSqljqsl(Long orgId, String number, Long taxauthority, String jnqx, Date skssqq, Date skssqz) {
        if (orgId != 0L && EmptyCheckUtils.isNotEmpty((Object)number) && EmptyCheckUtils.isNotEmpty((Object)skssqq) && EmptyCheckUtils.isNotEmpty((Object)skssqz)) {
            QFilter q9;
            QFilter q8;
            DynamicObject object;
            int count = 0;
            if (JNQX_AYSB.equals(jnqx)) {
                count = -1;
            } else if (JNQX_AJSB.equals(jnqx)) {
                count = -3;
            }
            Date startdate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)skssqq, (int)count));
            Date enddate = DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)skssqz, (int)count));
            QFilter q1 = new QFilter("org", "=", (Object)orgId);
            QFilter q2 = new QFilter("skssqq", "=", (Object)startdate);
            QFilter q3 = new QFilter("skssqz", "=", (Object)enddate);
            QFilter q4 = new QFilter("type", "=", (Object)"szys_a");
            QFilter q5 = new QFilter("taxauthority", "=", (Object)taxauthority);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
            List sbbids = collection.stream().map(d -> d.getString("id")).collect(Collectors.toList());
            QFilter q6 = new QFilter("szybh", "=", (Object)number);
            QFilter q7 = new QFilter("sbbid", "in", sbbids);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcwat_declare_a_base", (String)"sbbid", (QFilter[])new QFilter[]{q6, q7});
            if (EmptyCheckUtils.isNotEmpty((Object)dynamicObject) && EmptyCheckUtils.isNotEmpty((Object)(object = QueryServiceHelper.queryOne((String)"tcwat_declare_a_tax", (String)"bqljqsl", (QFilter[])new QFilter[]{q8 = new QFilter("sbbid", "=", dynamicObject.get("sbbid")), q9 = new QFilter("ewblxh", "=", (Object)"resourcetax")})))) {
                return object.getBigDecimal("bqljqsl");
            }
        }
        return BigDecimal.ZERO;
    }
}

