/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.helper.OrgServiceHelper;
import kd.taxc.tdm.common.util.TreeUtils;
import org.apache.commons.lang3.ObjectUtils;

public class WithholdingBatchImportPlugin
extends BatchImportPlugin {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private static final String TAXPAYERNAME = "taxpayername";
    private static final String TAXPAYERNUMBER = "taxpayernumber";
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    protected void beforeSave(List<ImportBillData> datas, ImportLogger logger) {
        super.beforeSave(datas, logger);
        Iterator<ImportBillData> partList = datas.iterator();
        while (partList.hasNext()) {
            ImportBillData data = partList.next();
            String orgNumber = (String)data.getData().getJSONObject("org").get("number");
            Long orgId = this.orgMap.get(orgNumber);
            Integer index = data.getStartIndex();
            if (orgId == null) {
                DynamicObjectCollection col = OrgServiceHelper.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"number", (Object)orgNumber));
                if (col != null && col.size() > 0) {
                    orgId = ((DynamicObject)col.get(0)).getLong("id");
                    if (orgId == 0L) {
                        logger.log(index, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7%1$s\u6570\u636e\u4e0d\u5b58\u5728", (String)"WithholdingBatchImportPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), orgNumber)).fail();
                        this.remove(datas, partList);
                        continue;
                    }
                    this.orgMap.put(orgNumber, orgId);
                } else {
                    logger.log(index, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7%1$s\u6570\u636e\u4e0d\u5b58\u5728", (String)"WithholdingBatchImportPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), orgNumber)).fail();
                    this.remove(datas, partList);
                    continue;
                }
            }
            JSONArray withholdingitems = data.getData().getJSONArray("withholdingitems");
            int items = data.getData().getJSONArray("withholdingitems").size();
            BigDecimal amount = new BigDecimal("0");
            for (int i = 0; i < items; ++i) {
                Object item = withholdingitems.get(i);
                Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)item), Map.class);
                String actualpayment = map.get("actualpayment").toString();
                amount = amount.add(new BigDecimal(actualpayment));
            }
            if (!amount.toString().equals(data.getData().get((Object)"amount"))) {
                logger.log(index, String.format(ResManager.loadKDString((String)"%1$s\u91d1\u989d\u5408\u8ba1\u8f93\u5165\u9519\u8bef", (String)"WithholdingBatchImportPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), data.getData().get((Object)"amount").toString())).fail();
                this.remove(datas, partList);
                continue;
            }
            QFilter f2 = new QFilter("org.number", "=", (Object)orgNumber);
            DynamicObject taxpayerObject = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)"istaxpayer,org.id,taxpayer as taxpayername,unifiedsocialcode as taxpayernumber", (QFilter[])new QFilter[]{f2});
            if (!taxpayerObject.getBoolean("istaxpayer")) {
                logger.log(index, ResManager.loadKDString((String)"\u65e0\u6cd5\u5f15\u5165\u975e\u7eb3\u7a0e\u4e3b\u4f53\u7684\u4ee3\u6263\u4ee3\u7f34\u51ed\u8bc1\u3002", (String)"WithholdingBatchImportPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                this.remove(datas, partList);
                continue;
            }
            if (taxpayerObject.getString(TAXPAYERNAME).equals("") && taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                logger.log(index, ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u540d\u79f0\u548c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"WithholdingBatchImportPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                this.remove(datas, partList);
                continue;
            }
            if (taxpayerObject.getString(TAXPAYERNAME).equals("") && !taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                logger.log(index, ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u540d\u79f0\u3002", (String)"WithholdingBatchImportPlugin_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                this.remove(datas, partList);
                continue;
            }
            if (!taxpayerObject.getString(TAXPAYERNAME).equals("") && taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                logger.log(index, ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"WithholdingBatchImportPlugin_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                this.remove(datas, partList);
                continue;
            }
            HashMap dataMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data.getData()), HashMap.class);
            dataMap.put("datasource", "2");
            dataMap.put("billno", String.valueOf(data.getData().get((Object)"taxcode")));
            dataMap.put("period", data.getData().get((Object)"period").toString());
            dataMap.put("sourcesys", ResManager.loadKDString((String)"\u82cd\u7a79", (String)"WithholdingBatchImportPlugin_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
            dataMap.put("billstatus", "C");
            dataMap.put(TAXPAYERNAME, taxpayerObject.getString(TAXPAYERNAME));
            dataMap.put(TAXPAYERNUMBER, taxpayerObject.getString(TAXPAYERNUMBER));
            data.setData(JSONObject.parseObject((String)JSONObject.toJSON((Object)dataMap).toString()));
        }
    }

    private void remove(List<ImportBillData> data, Iterator<ImportBillData> partList) {
        if (ObjectUtils.isNotEmpty(data)) {
            partList.remove();
        }
    }
}

