/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountImportPlugin
extends BatchImportPlugin {
    public String getDefaultKeyFields() {
        return "org,number";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        String importType = option.get("importtype").toString();
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            String number = (String)data.getData().get((Object)"number");
            if (StringUtils.isBlank((CharSequence)number)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountImportPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            if (data.getData().get((Object)"org") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountImportPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            List<QFilter> filters = this.getFilter(data);
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"tdm_account", (String)"id,number", (QFilter[])filters.toArray(new QFilter[filters.size()]));
            if (colls != null && colls.size() > 0) {
                Map<String, DynamicObject> docmap = colls.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
                if (docmap.containsKey(number) && "new".equals(importType)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u79d1\u76ee:%s", (String)"AccountImportPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]), number)).fail();
                    it.remove();
                    continue;
                }
                if (data.getData().get((Object)"parent") != null) {
                    String parent = (String)((Map)data.getData().get((Object)"parent")).get("number");
                    if (!docmap.containsKey(parent)) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7236\u7ea7\u79d1\u76ee\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"AccountImportPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                        it.remove();
                        continue;
                    }
                    DynamicObject obj = docmap.get(parent);
                    String parentid = obj.getString("id");
                    JSONObject parentObj = new JSONObject();
                    parentObj.put("importprop", (Object)"id");
                    parentObj.put("id", (Object)parentid);
                    data.getData().put("parent", (Object)parentObj);
                }
            } else if (data.getData().get((Object)"parent") != null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7236\u7ea7\u79d1\u76ee\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"AccountImportPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            data.getData().put("sourcesystem", (Object)ResManager.loadKDString((String)"\u82cd\u7a79", (String)"AccountImportPlugin_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]));
        }
        super.beforeSave(billdatas, logger);
    }

    private List<QFilter> getFilter(ImportBillData data) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        ArrayList<String> numberlist = new ArrayList<String>();
        String number = (String)data.getData().get((Object)"number");
        numberlist.add(number);
        if (data.getData().get((Object)"parent") != null) {
            String parent = (String)((Map)data.getData().get((Object)"parent")).get("number");
            numberlist.add(parent);
        }
        QFilter numberFilter = new QFilter("number", "in", numberlist);
        filters.add(numberFilter);
        String orgNumber = (String)((Map)data.getData().get((Object)"org")).get("number");
        QFilter orgFilter = new QFilter("org.number", "=", (Object)orgNumber);
        filters.add(orgFilter);
        return filters;
    }
}

