/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin.assetlist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.tdm.common.enums.AssetEnum;
import kd.taxc.tdm.common.util.EmptyCheckUtils;

public class AssetListOp
extends AbstractOperationServicePlugIn {
    private static final String ASSET_LIST_DATA = "tdm_asset_data";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        List<DynamicObject> selectedRows = Arrays.asList(e.getDataEntities());
        String key = this.getOption().getVariableValue("key");
        AssetEnum asset = AssetEnum.getInstance((String)key);
        if (EmptyCheckUtils.isEmpty((Object)asset)) {
            return;
        }
        OperationResult saveResult = this.dialog(key, asset.getFieldName(), asset.getMessage(), selectedRows);
        this.rebuildOpResult(e, saveResult);
        if (this.getOperationResult().isSuccess()) {
            this.getOperationResult().setMessage(asset.getMessage());
        }
    }

    private OperationResult dialog(String itemKey, String filedName, String name, List<DynamicObject> selectedRows) {
        ArrayList editList = new ArrayList();
        selectedRows.forEach(e -> {
            if (null == e || null == e.getPkValue()) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)e.getPkValue(), (String)ASSET_LIST_DATA);
            dynamicObject.set(filedName, (Object)itemKey);
            editList.add(dynamicObject);
        });
        return OperationServiceHelper.executeOperate((String)"save", (String)ASSET_LIST_DATA, (DynamicObject[])editList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    protected void rebuildOpResult(BeginOperationTransactionArgs e, OperationResult saveOpResult) {
        if (!saveOpResult.isSuccess()) {
            ArrayList<OperateErrorInfo> allError = new ArrayList<OperateErrorInfo>(16);
            List allErrorOrValidateInfo = saveOpResult.getAllErrorOrValidateInfo();
            HashMap<Long, Boolean> billErrorMap = new HashMap<Long, Boolean>();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                if (!(iOperateInfo instanceof OperateErrorInfo)) continue;
                OperateErrorInfo error = (OperateErrorInfo)iOperateInfo;
                allError.add(error);
                billErrorMap.put((Long)error.getPkValue(), Boolean.TRUE);
            }
            this.getOperationResult().setAllErrorInfo(allError);
            List<DynamicObject> successObjs = Stream.of(e.getDataEntities()).filter(obj -> !billErrorMap.containsKey(obj.getLong("id"))).collect(Collectors.toList());
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }
}

