/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin.avgtaxrate;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AvgTaxRateOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection taxationsys = QueryServiceHelper.query((String)"bd_taxationsys", (String)"id,enable", (QFilter[])filter.toArray());
        final List taxationsysIds = taxationsys.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection taxcategorys = QueryServiceHelper.query((String)"bd_taxcategory", (String)"id,enable,taxationsysid", (QFilter[])filter.toArray());
        final List taxcategoryIds = taxcategorys.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        final Map<Long, Long> categorySysIdMap = taxcategorys.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("taxationsysid"), (k1, k2) -> k1));
        DynamicObjectCollection taxareagroups = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,enable", (QFilter[])filter.toArray());
        final List bastaxTaxareagroupIds = taxareagroups.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection industrycodes = QueryServiceHelper.query((String)"tpo_tcvat_industrycode", (String)"id,enable", (QFilter[])filter.toArray());
        final List industrycodesIds = industrycodes.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String msg;
                    String msg2;
                    DynamicObject dyo = dataEntity.getDataEntity();
                    long id = dyo.getLong("id");
                    Date activedate = dyo.getDate("activedate");
                    Date expdate = dyo.getDate("expdate");
                    BigDecimal minrate = dyo.getBigDecimal("minrate");
                    BigDecimal maxrate = dyo.getBigDecimal("maxrate");
                    if (activedate != null && expdate != null && expdate.compareTo(activedate) <= 0) {
                        msg2 = ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u9700\u8981\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AvgTaxRateOp_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg2);
                        continue;
                    }
                    if (minrate != null && maxrate != null && minrate.compareTo(maxrate) > 0) {
                        msg2 = ResManager.loadKDString((String)"\u6700\u5927\u7a0e\u8d1f\u7387\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u7a0e\u8d1f\u7387\u3002", (String)"AvgTaxRateOp_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg2);
                        continue;
                    }
                    Long taxationsys = AvgTaxRateOp.this.getLongValue(dyo, "taxationsys");
                    Long taxcategory = AvgTaxRateOp.this.getLongValue(dyo, "taxcategory");
                    Long taxareagroup = AvgTaxRateOp.this.getLongValue(dyo, "taxareagroup");
                    Long industrycode = AvgTaxRateOp.this.getLongValue(dyo, "industrycode");
                    QFilter filter = new QFilter("taxationsys", "=", (Object)taxationsys).and("taxareagroup", "=", (Object)taxareagroup).and("industrycode", "=", (Object)industrycode).and("taxcategory", "=", (Object)taxcategory).and("id", "!=", (Object)id);
                    DynamicObjectCollection refTaxrateList = QueryServiceHelper.query((String)"tdm_ref_taxrate", (String)"number,activedate,expdate", (QFilter[])filter.toArray());
                    boolean checkDate = AvgTaxRateOp.this.checkDate(refTaxrateList, activedate, expdate);
                    if (!checkDate) {
                        msg = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6709\u6548\u671f\u5185\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e24\u4e2a\u53c2\u8003\u7a0e\u8d1f\u7387\u3002", (String)"AvgTaxRateOp_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg);
                        continue;
                    }
                    if (!taxationsysIds.contains(taxationsys)) {
                        msg = ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u53ef\u7528\u3002", (String)"AvgTaxRateOp_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg);
                        continue;
                    }
                    if (!taxcategoryIds.contains(taxcategory)) {
                        msg = ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u53ef\u7528\u3002", (String)"AvgTaxRateOp_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg);
                        continue;
                    }
                    if (!bastaxTaxareagroupIds.contains(taxareagroup)) {
                        msg = ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u4e0d\u53ef\u7528\u3002", (String)"AvgTaxRateOp_5", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg);
                        continue;
                    }
                    if (industrycode != 0L && !industrycodesIds.contains(industrycode)) {
                        msg = ResManager.loadKDString((String)"\u884c\u4e1a\u4e0d\u53ef\u7528\u3002", (String)"AvgTaxRateOp_6", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, msg);
                        continue;
                    }
                    if (categorySysIdMap.getOrDefault(taxcategory, 0L).equals(taxationsys)) continue;
                    msg = ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0e\u7a0e\u79cd\u4e0d\u5339\u914d\u3002", (String)"AvgTaxRateOp_7", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        });
    }

    private boolean checkDate(DynamicObjectCollection tdmRefTaxrateList, Date activedate, Date expdate) {
        if (CollectionUtils.isEmpty((Collection)tdmRefTaxrateList)) {
            return true;
        }
        for (DynamicObject rate : tdmRefTaxrateList) {
            Date activedateDb = rate.getDate("activedate");
            Date expdateDb = rate.getDate("expdate");
            if (activedateDb.compareTo(expdate) > 0 || expdateDb.compareTo(activedate) < 0) continue;
            return false;
        }
        return true;
    }

    private Long getLongValue(DynamicObject dyo, String filed) {
        Object o = dyo.get(filed);
        if (o == null) {
            return 0L;
        }
        if (o instanceof DynamicObject) {
            return ((DynamicObject)o).getLong("id");
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return 0L;
    }
}

