/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.opplugin.realestateRevCost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.business.realestateRevCost.DevLandInfoBusiness;

public class DevLandInfoOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("stage");
        e.getFieldKeys().add("entryentity");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                if ("save".equals(this.getOperateKey())) {
                    ArrayList<Long> projectids = new ArrayList<Long>();
                    ArrayList<Long> stageids = new ArrayList<Long>();
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        Long project = (Long)dataEntity.getDataEntity().get("project.id");
                        Long stage = (Long)dataEntity.getDataEntity().get("stage.id");
                        projectids.add(project);
                        stageids.add(stage);
                    }
                    TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
                    HashSet set1 = listTaxResult.getData() != null ? new HashSet((Collection)listTaxResult.getData()) : new HashSet();
                    DynamicObjectCollection queryProjectByIds = DevLandInfoBusiness.queryProjectByIds(projectids);
                    Map<Long, Long> proToOrgMap = queryProjectByIds.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.getLong("taxorg"), (m, n) -> m));
                    DynamicObjectCollection queryStageByIds = DevLandInfoBusiness.queryStageByIds(stageids);
                    Map<Long, Long> stageToProMap = queryStageByIds.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.getLong("taxproject"), (m, n) -> m));
                    List ids = Arrays.stream(this.dataEntities).map(a -> a.getBillPkId()).filter(b -> b != null).collect(Collectors.toList());
                    DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_develop_land_info"));
                    Map<Object, List<DynamicObject>> entryIdMap = Arrays.stream(load).flatMap(a -> a.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.groupingBy(a -> a.get("id")));
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String msg;
                        DynamicObject dynamicObject = dataEntity.getDataEntity();
                        Long orgid = (Long)dataEntity.getDataEntity().get("org.id");
                        Long project = (Long)dataEntity.getDataEntity().get("project.id");
                        Long stage = (Long)dataEntity.getDataEntity().get("stage.id");
                        if (orgid != null && !set1.contains(orgid)) {
                            msg = ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7eb3\u7a0e\u4e3b\u4f53\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DevLandInfoOpPlugin_0", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                            this.addFatalErrorMessage(dataEntity, msg);
                            continue;
                        }
                        if (orgid != null && !orgid.equals(proToOrgMap.get(project))) {
                            msg = ResManager.loadKDString((String)"\u8be5\u7a0e\u52a1\u9879\u76ee\u4e0d\u5c5e\u4e8e\u8be5\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DevLandInfoOpPlugin_1", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                            this.addFatalErrorMessage(dataEntity, msg);
                            continue;
                        }
                        if (project != null && !project.equals(stageToProMap.get(stage))) {
                            msg = ResManager.loadKDString((String)"\u8be5\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u4e0d\u5c5e\u4e8e\u8be5\u7a0e\u52a1\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DevLandInfoOpPlugin_2", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                            this.addFatalErrorMessage(dataEntity, msg);
                            continue;
                        }
                        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                        boolean valid = true;
                        HashSet<String> sqSet = new HashSet<String>();
                        for (DynamicObject object : dynamicObjectCollection) {
                            String format;
                            Long entryid = object.getLong("id");
                            Date bgdjsq = object.getDate("bgdjsq");
                            if (entryid == null || entryid == 0L) {
                                boolean declared = DevLandInfoBusiness.isDeclared((Date)bgdjsq, (Long)orgid, (Boolean)false);
                                if (declared) {
                                    String msg2 = ResManager.loadKDString((String)"\u767b\u8bb0\u671f\u95f4\u6570\u636e\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u767b\u8bb0\u4fee\u6539\u4fe1\u606f\u3002", (String)"DevLandInfoOpPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                                    this.addFatalErrorMessage(dataEntity, msg2);
                                    valid = false;
                                    break;
                                }
                            } else if (entryIdMap.containsKey(entryid)) {
                                boolean declared;
                                DynamicObject dynamicObject1 = entryIdMap.get(entryid).get(0);
                                if (bgdjsq != null && !bgdjsq.equals(dynamicObject1.getDate("bgdjsq")) && (declared = DevLandInfoBusiness.isDeclared((Date)bgdjsq, (Long)orgid, (Boolean)false))) {
                                    String msg3 = ResManager.loadKDString((String)"\u767b\u8bb0\u671f\u95f4\u6570\u636e\u5df2\u7533\u62a5\uff0c\u65e0\u6cd5\u767b\u8bb0\u4fee\u6539\u4fe1\u606f\u3002", (String)"DevLandInfoOpPlugin_3", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                                    this.addFatalErrorMessage(dataEntity, msg3);
                                    valid = false;
                                    break;
                                }
                            }
                            if (sqSet.contains(format = DateUtils.format((Date)bgdjsq, (String)"yyyy-MM"))) {
                                String msg4 = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u5b58\u5728\u76f8\u540c\u53d8\u66f4\u767b\u8bb0\u5c5e\u671f\u7684\u6570\u636e\u3002", (String)"DevLandInfoOpPlugin_4", (String)"taxc-tdm-opplugin", (Object[])new Object[0]);
                                this.addFatalErrorMessage(dataEntity, msg4);
                                valid = false;
                                break;
                            }
                            sqSet.add(format);
                        }
                        if (valid) continue;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                entryentity.sort((a, b) -> {
                    if (a == null && b != null) {
                        return -1;
                    }
                    if (a != null && b == null) {
                        return 1;
                    }
                    return a.getDate("bgdjsq").compareTo(b.getDate("bgdjsq"));
                });
                for (int i = 0; i < entryentity.size(); ++i) {
                    ((DynamicObject)entryentity.get(i)).set("seq", (Object)(i + 1));
                }
                Long stage = (Long)dataEntity.get("stage_id");
                BigDecimal areaSum = DevLandInfoBusiness.queryRoomsByStage((Long)stage);
                dataEntity.set("dsjrzksmjtb", (Object)areaSum);
            }
        }
    }
}

