/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.tdm.business.account.TaxcAccountBusiness;
import kd.taxc.tdm.common.util.PermissionUtils;
import org.apache.commons.collections.CollectionUtils;

public class AccountListPlugin
extends AbstractTreeListPlugin {
    private static Log logger = LogFactory.getLog(AccountListPlugin.class);
    private static final String VIEWID = "10";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        QFilter org = this.getQFilter(filterValues);
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel != null && org != null) {
            List filter = treeModel.getTreeFilter();
            filter.add(org);
            this.getTreeListView().focusRootNode();
            this.getTreeModel().getRoot().setChildren(new ArrayList(1));
            this.refreshTreeView();
        }
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)new TreeListView(){

            public void refresh() {
                TreeNode root = this.getTreeModel().getRoot();
                root.setChildren(new ArrayList(1));
                super.refresh();
            }
        });
    }

    private void refreshTreeView() {
        TreeNode node;
        String nodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!StringUtils.isEmpty((CharSequence)nodeId) && (node = this.getTreeModel().refreshNode((Object)nodeId)) != null) {
            this.getTreeListView().getTreeView().updateNode(node);
            this.getTreeListView().getTreeView().focusNode(node);
            this.getTreeListView().getTreeView().treeNodeClick(node.getParentid(), nodeId);
        }
    }

    private QFilter getQFilter(Map<String, List<Map<String, List<Object>>>> filterValues) {
        List<Map<String, List<Object>>> customFiterList = filterValues.get("customfilter");
        List<Map<String, List<Object>>> schemeFilterList = filterValues.get("schemefilter");
        QFilter org = null;
        if (customFiterList != null) {
            org = this.getOrgFilter(customFiterList);
        } else if (schemeFilterList != null) {
            org = this.getOrgFilter(schemeFilterList);
        }
        return org;
    }

    private QFilter getOrgFilter(List<Map<String, List<Object>>> filterList) {
        QFilter org = null;
        for (Map<String, List<Object>> filter : filterList) {
            List<Object> fieldNames = filter.get("FieldName");
            if (fieldNames.get(0).toString().startsWith("org.id")) {
                List<Object> orgIds = filter.get("Value");
                org = new QFilter(fieldNames.get(0).toString(), "=", (Object)Long.parseLong(orgIds.get(0).toString()));
                this.getPageCache().put("CACHE_DEFAULT_ORG", String.valueOf(orgIds.get(0)));
                break;
            }
            if (!fieldNames.get(0).toString().startsWith("org.name")) continue;
            List<Object> orgNames = filter.get("Value");
            String orgName = orgNames.get(0).toString();
            QFilter orgQuery = new QFilter("org.name", "=", (Object)orgName);
            QFilter viewFilter = new QFilter("view", "=", (Object)Long.parseLong(VIEWID));
            DynamicObjectCollection orgIds = QueryServiceHelper.query((String)"bos_org_structure", (String)"id,org", (QFilter[])new QFilter[]{orgQuery, viewFilter});
            if (orgIds.isEmpty()) continue;
            DynamicObject orgObj = (DynamicObject)orgIds.get(0);
            String orgId = orgObj.getString("org");
            org = new QFilter("org.id", "=", (Object)Long.parseLong(orgId));
            this.getPageCache().put("CACHE_DEFAULT_ORG", orgId);
            break;
        }
        return org;
    }

    public void initializeTree(EventObject e) {
        ListView listView = (ListView)this.getView();
        if (this.getView().getParentView() == null) {
            return;
        }
        Object orgid = this.getOrgId();
        if (orgid != null) {
            QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
            TreeListModel treeModle = (TreeListModel)listView.getTreeListView().getTreeModel();
            if (null != treeModle) {
                treeModle.getTreeFilter().add(qFilter);
            }
        } else {
            Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView());
            this.getPageCache().put("CACHE_DEFAULT_ORG", String.valueOf(orgId));
            this.getTreeModel().getTreeFilter().add(new QFilter("org.id", "=", (Object)orgId));
        }
    }

    private Object getOrgId() {
        Long orgid;
        if (this.getView().getParentView() instanceof ReportView) {
            ReportView reportView = (ReportView)this.getView().getParentView();
            orgid = "tdm_trial_balance_report".equalsIgnoreCase(reportView.getFormId()) ? Long.valueOf(this.getView().getParentView().getModel().getDataEntity().getLong("org.id")) : Long.valueOf(OrgUnitServiceHelper.getRootOrgId());
        } else {
            Map cusmap = this.getView().getParentView().getFormShowParameter().getCustomParams();
            if (cusmap.containsKey("orgid")) {
                orgid = cusmap.get("orgid");
            } else {
                cusmap = this.getView().getFormShowParameter().getCustomParams();
                orgid = cusmap.get("orgid");
            }
        }
        return orgid;
    }

    public void setFilter(SetFilterEvent e) {
        if (this.getView().getParentView() == null) {
            return;
        }
        Object orgid = this.getOrgId();
        if (orgid != null) {
            QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
            e.getQFilters().add(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothingdelete".equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                if (billlist != null) {
                    if (billlist.getSelectedRows() != null && billlist.getSelectedRows().size() > 0) {
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u201c%d\u201d\u6761\u6570\u636e\uff0c\u5c06\u4e00\u5e76\u5220\u9664\u5176\u4e0b\u7ea7\u6570\u636e\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"AccountListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), billlist.getSelectedRows().size()), MessageBoxOptions.YesNo, confirmCallBackListener);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002\u3002", (String)"AccountListPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                }
            } else if ("donothingdisable".equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection collection = billlist.getSelectedRows();
                ArrayList<Object> pks = new ArrayList<Object>();
                for (ListSelectedRow rowObj : collection) {
                    pks.add(rowObj.getPrimaryKeyValue());
                }
                QFilter qFilter = new QFilter("id", "in", pks).and(new QFilter("isleaf", "=", (Object)"0"));
                DynamicObjectCollection objs = QueryServiceHelper.query((String)"tdm_account", (String)"id,number,isleaf", (QFilter[])new QFilter[]{qFilter});
                if (CollectionUtils.isNotEmpty((Collection)objs)) {
                    String numbers = objs.stream().map(o -> o.getString("number")).collect(Collectors.joining(","));
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("disable", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u6709\u4e0b\u7ea7\u79d1\u76ee\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u57fa\u7840\u8d44\u6599\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccountListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, confirmCallBackListener);
                } else {
                    this.getView().invokeOperation("disable");
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refresh();
        }
    }

    public void refresh() {
        TreeNode root = this.getTreeModel().getRoot();
        root.setChildren(new ArrayList(1));
        this.getTreeListView().refreshTreeNode(root.getId());
        this.refreshTreeView();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (org.apache.commons.lang.StringUtils.equals((String)"delete", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Long time1 = System.currentTimeMillis();
            this.deleteData();
            Long time2 = System.currentTimeMillis();
            logger.error("deleteData \u8017\u8d39:" + (time2 - time1));
        }
        if (StringUtils.equals((CharSequence)"disable", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("disable");
        }
    }

    private void deleteData() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName("tdm_account_delete");
        jobInfo.setNumber("tdm_account_delete");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.taxc.tdm.formplugin.task.AccountDeleteTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>();
        BillList billlist = (BillList)this.getControl("billlistap");
        params.put("selectedNumbers", this.getSelectedRows().stream().map(o -> o.getNumber()).collect(Collectors.toList()));
        params.put("pkIds", billlist.getSelectedRows().getPrimaryKeyValues());
        params.put("orgId", this.getPageCache().get("CACHE_DEFAULT_ORG"));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u5220\u9664\u4efb\u52a1", (String)"AccountListPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.taxc.bdtaxr.common.taxdeclare.draft.CalcTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            TaskInfo taskInfo;
            Map result;
            String taskInfoStr;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                if ("false".equals(map.get("success"))) {
                    this.getView().showErrorNotification(String.valueOf(map.get("message")));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AccountListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    this.refresh();
                }
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String orgId = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            e.getFilters().add(new QFilter("org", "=", (Object)Long.parseLong(orgId)));
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else {
            List treeFilter = this.getTreeModel().getTreeFilter();
            e.setChildNodes(TaxcAccountBusiness.queryChildNode((String)currNodeId, (List)treeFilter, null));
        }
    }
}

