/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;

public class BalanceImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(BalanceImportPlugin.class);
    private static final String DATASOURCE = "datasource";
    private static final String SOURCE_SYS = "sourcesys";
    private static final String ACCOUNT_YEAR = "accountyear";
    private static final String ACCOUNT_MONTH = "accountperiod";
    private static final String regex = "\\d{4}";
    private Map<String, Long> orgMap = new HashMap<String, Long>();

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        HashMap<String, String> dataMap = new HashMap<String, String>(billdatas.size());
        while (it.hasNext()) {
            boolean isDuplicateData;
            Map option;
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            if (data.getData().get((Object)"org") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            if (data.getData().get((Object)ACCOUNT_YEAR) == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u5e74\u5ea6\u3002", (String)"BalanceImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            String orgNumber = (String)((Map)data.getData().get((Object)"org")).get("number");
            Long orgId = this.orgMap.get(orgNumber);
            if (orgId == null) {
                QFilter qFilter = new QFilter("number", "=", (Object)orgNumber).and(new QFilter("fisaccounting", "=", (Object)"1"));
                DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (org != null) {
                    orgId = org.getLong("id");
                    this.orgMap.put(orgNumber, orgId);
                } else {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", (String)"BalanceImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber)).fail();
                    it.remove();
                    continue;
                }
            }
            if (!((String)data.getData().get((Object)ACCOUNT_YEAR)).matches(regex)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy\u3002", (String)"BalanceImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            Map orgIdMap = (Map)data.getData().get((Object)"org");
            orgIdMap.put("id", orgId);
            data.getData().put("accountcycle", (Object)(data.getData().get((Object)ACCOUNT_YEAR) + "-" + data.getData().get((Object)ACCOUNT_MONTH) + "-01 00:00:00"));
            String billNo = (String)data.getData().get((Object)"billno");
            HashMap<String, Object> balanceMap = new HashMap<String, Object>();
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter billNoFilter = new QFilter("number", "=", (Object)billNo);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject balance = BusinessDataServiceHelper.loadSingleFromCache((String)"tdm_account", (String)"id", (QFilter[])new QFilter[]{orgFilter, billNoFilter, enableFilter});
            if (balance == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff1a\u79d1\u76ee\u7f16\u7801 # billno \u201c%s\u201d", (String)"BalanceImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), billNo)).fail();
                it.remove();
                continue;
            }
            balanceMap.put("id", balance.get("id"));
            data.getData().put("balance", balanceMap);
            String isAdjust = data.getData().getString("isadjust");
            if (StringUtil.equals((CharSequence)FinanceTemplateUtils.convertForImport(isAdjust), (CharSequence)"0") || !data.getData().containsKey((Object)"adjperi")) {
                data.getData().put("adjperi", (Object)"");
            }
            if ((option = this.ctx.getOption()).get("importtype").toString().equals("new") && (isDuplicateData = this.validateDuplicateData((Map<String, Object>)data.getData(), logger, billNo, orgId, dataMap, index))) {
                it.remove();
                continue;
            }
            data.getData().put(DATASOURCE, (Object)ResManager.loadKDString((String)"\u6a21\u677f\u5f15\u5165", (String)"BalanceImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            data.getData().put(SOURCE_SYS, (Object)ResManager.loadKDString((String)"\u82cd\u7a79", (String)"BalanceImportPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        super.beforeSave(billdatas, logger);
    }

    private boolean checkAccountYear(String year) {
        try {
            DateUtils.stringToDate((String)year, (String)"yyyy");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateDuplicateData(Map<String, Object> data, ImportLogger importLog, String billNo, Long orgId, Map<String, String> dataMap, int index) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        String accountYear = (String)data.get(ACCOUNT_YEAR);
        String accountPeriod = (String)data.get(ACCOUNT_MONTH);
        String booktype = data.get("accountbookstype") == null ? "" : (String)data.get("accountbookstype");
        String isAdjust = data.get("isadjust") == null ? "0" : FinanceTemplateUtils.convertForImport((String)data.get("isadjust"));
        String adjPeri = (String)data.get("adjperi");
        QFilter accountYearFilter = new QFilter(ACCOUNT_YEAR, "=", (Object)accountYear);
        QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
        QFilter accountPeriodFilter = new QFilter(ACCOUNT_MONTH, "=", (Object)accountPeriod);
        QFilter booktypeFilter = new QFilter("accountbookstype", "=", (Object)booktype);
        QFilter adjustFilter = new QFilter("isadjust", "=", (Object)isAdjust);
        QFilter adjperFilter = new QFilter("adjPeri", "=", (Object)adjPeri);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(qFilter);
        qFilterList.add(accountYearFilter);
        qFilterList.add(billNoFilter);
        qFilterList.add(accountPeriodFilter);
        qFilterList.add(booktypeFilter);
        qFilterList.add(adjustFilter);
        qFilterList.add(adjperFilter);
        QFilter[] qFilterArray = new QFilter[qFilterList.size()];
        qFilterList.toArray(qFilterArray);
        boolean balanceNew = QueryServiceHelper.exists((String)"tdm_balance_new", (QFilter[])qFilterArray);
        if (balanceNew) {
            importLog.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868\u6570\u636e\u91cd\u590d\uff0c\u5982\u9700\u66f4\u65b0\u6570\u636e\uff0c\u5f15\u5165\u65f6\u8bf7\u9009\u62e9\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u6216\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d", (String)"BalanceImportPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
            return true;
        }
        List entityList = (List)data.get("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entityList)) {
            List accountDimensions = entityList.stream().map(o -> (String)o.get("accountdimension")).collect(Collectors.toList());
            QFilter accountDimensionFilter = new QFilter("entryentity.accountdimension", "in", accountDimensions);
            qFilterList.add(accountDimensionFilter);
            qFilterArray = new QFilter[qFilterList.size()];
            qFilterList.toArray(qFilterArray);
            balanceNew = QueryServiceHelper.exists((String)"tdm_balance_new", (QFilter[])qFilterArray);
            if (balanceNew) {
                importLog.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868\u6570\u636e\u91cd\u590d\uff0c\u5982\u9700\u66f4\u65b0\u6570\u636e\uff0c\u5f15\u5165\u65f6\u8bf7\u9009\u62e9\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u6216\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d", (String)"BalanceImportPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                return true;
            }
        }
        StringBuilder keybuilder = new StringBuilder();
        keybuilder.append(orgId).append("-").append(billNo).append("-").append(accountYear).append("-").append(accountPeriod).append("-").append(booktype).append("-").append(isAdjust).append("-").append(adjPeri);
        String key = keybuilder.toString();
        if (dataMap.containsKey(key)) {
            importLog.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868\u6570\u636e\u91cd\u590d\uff0c\u5982\u9700\u66f4\u65b0\u6570\u636e\uff0c\u5f15\u5165\u65f6\u8bf7\u9009\u62e9\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u6216\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d", (String)"BalanceImportPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
            return true;
        }
        dataMap.put(key, key);
        return false;
    }
}

