/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.constant.InvoiceSubEntityMappingEnum;
import kd.taxc.tdm.formplugin.utils.TreeUtils;
import org.apache.commons.collections.CollectionUtils;

public class CustomsPaymenImportPlugin
implements IImportPlugin {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private String entryEntityName = null;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray entities;
        DynamicObject dynamicObject;
        if (data.get("org") == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomsPaymenImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        if (data.get("period") == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomsPaymenImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        String orgNumber = (String)((Map)data.get("org")).get("number");
        Long orgId = this.orgMap.get(orgNumber);
        if (orgId == null) {
            DynamicObjectCollection col = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("number", orgNumber));
            if (CollectionUtils.isNotEmpty((Collection)col) && ((DynamicObject)col.get(0)).getLong("id") != 0L) {
                orgId = ((DynamicObject)col.get(0)).getLong("id");
                this.orgMap.put(orgNumber, orgId);
            } else {
                String msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7\u201c%s\u201d\u3002", (String)"CustomsPaymenImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(String.format(msg, orgNumber)));
                return false;
            }
        }
        data.put("datasource", "income");
        data.put("sourcesystem", ResManager.loadKDString((String)"\u82cd\u7a79", (String)"CustomsPaymenImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        Object specialtaxcode = data.get("specialtaxcode");
        String specialtaxcodeStr = String.valueOf(specialtaxcode);
        if (StringUtils.isEmpty((CharSequence)specialtaxcodeStr)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e13\u7528\u7f34\u6b3e\u4e66\u53f7\u7801\u201d\u3002", (String)"CustomsPaymenImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        data.put("billno", specialtaxcodeStr);
        if ("new".equals(option.get("importtype")) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tdm_customs_payment", (String)"specialtaxcode", (QFilter[])new QFilter[]{new QFilter("specialtaxcode", "=", specialtaxcode)})) != null) {
            String msg = ResManager.loadKDString((String)"\u4e13\u7528\u7f34\u6b3e\u4e66\u53f7\u7801\u91cd\u590d\u201c%s\u201d\u3002", (String)"CustomsPaymenImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(String.format(msg, dynamicObject.getString("specialtaxcode"))));
            return false;
        }
        data.put("period", DateUtils.stringToDate((String)((String)data.get("period")), (String)"yyyy-MM"));
        if (StringUtils.equals((CharSequence)"0", (CharSequence)((String)data.get("selectstatus")))) {
            data.put("cometermstatus", "not");
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)data.get("selectstatus"))) && StringUtils.equals((CharSequence)"0", (CharSequence)((String)data.get("certstatus")))) {
            data.put("cometermstatus", "yes");
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)data.get("selectstatus"))) && StringUtils.equals((CharSequence)"1", (CharSequence)((String)data.get("certstatus")))) {
            data.put("cometermstatus", "yesverify");
        }
        if (EmptyCheckUtils.isEmpty((Object)data.get("selectresult"))) {
            data.put("selectresult", "0");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.entryEntityName) && (entities = (JSONArray)data.get(this.entryEntityName)).size() == 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("seq", (Object)1);
            entities.add((Object)jsonObject);
            data.put(this.entryEntityName, entities);
        }
        return super.beforeImportData(data, option, importlogs);
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return super.importData(data, option, importlogs);
    }

    public BillEntityType getImportMainEntityType(String billFormId) {
        this.entryEntityName = null;
        this.entryEntityName = InvoiceSubEntityMappingEnum.getSubEntityNameByEntityName(billFormId);
        return super.getImportMainEntityType(billFormId);
    }
}

