/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.common.util.BaseDataUtil;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class CustomsPaymentListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs contInitEvent) {
        super.filterContainerInit(contInitEvent);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List dateList = new ArrayList();
        List orgs = new ArrayList();
        List signdateList = new ArrayList();
        if (null != customParams.get("period")) {
            dateList = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("period")), List.class);
        }
        if (null != customParams.get("signdate")) {
            signdateList = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("signdate")), List.class);
        }
        if (null != customParams.get("orgs")) {
            orgs = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("orgs")), List.class);
        }
        List commonFilters = contInitEvent.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if ("period".equalsIgnoreCase(fieldName) && !dateList.isEmpty()) {
                filterColumn.setDefaultValues(dateList);
            }
            if ("signdate".equalsIgnoreCase(fieldName) && !dateList.isEmpty()) {
                filterColumn.setDefaultValues(signdateList);
            }
            if (!fieldName.startsWith("org.")) continue;
            if (!orgs.isEmpty()) {
                filterColumn.setDefaultValues(orgs.stream().map(s -> s.toString()).collect(Collectors.toList()));
                continue;
            }
            filterColumn.setDefaultValues(new Object[]{BaseDataUtil.getDefaultOrg((IFormView)this.getView())});
        }
    }

    public void setFilter(SetFilterEvent e) {
        HasPermOrgResult hasPermOrgResult;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> orgOptional = qFilters.stream().filter(s -> s.getProperty().startsWith("org.")).findFirst();
        if (!orgOptional.isPresent() && EmptyCheckUtils.isNotEmpty((Object)(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView()))) && !hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            qFilters.add(new QFilter("org.id", "in", (Object)orgList));
        }
    }
}

