/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TemplateGroupBaseDataPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tdm.common.enums.BooleanEnum;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.BeanCopyUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.element.TimeDeviatedEnum;

public class ElementListPlugin
extends TemplateGroupBaseDataPlugin {
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String RISK_DEFINITION = "tctrc_risk_definition";
    private static final String TDM_ELEMENT_GROUP = "tdm_element_group";
    private static final String DELETE_REOCRD = "DELETE_REOCRD";
    private static final String TDM_ELEMENT_TYPE = "tdm_element_type";
    private static final String BTNDEL = "btndel";
    private static final String BTNNEW = "btnnew";
    public static final List<String> BTN_KEY = Collections.unmodifiableList(Arrays.asList("btndel", "btnnew"));

    public void treeToolbarClick(EventObject e) {
        QFilter filter;
        DynamicObject object;
        ITreeModel treeModel = this.getTreeModel();
        String rootid = treeModel.getRoot().getId();
        String nodeid = treeModel.getCurrentNodeId().toString();
        Control ctl = (Control)e.getSource();
        String key = ctl.getKey();
        if (BTN_KEY.contains(key) && !nodeid.equals(rootid) && (object = QueryServiceHelper.queryOne((String)TDM_ELEMENT_TYPE, (String)"id,preset", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)Long.parseLong(nodeid))})) != null && object.getBoolean("preset")) {
            if (BTNDEL.equalsIgnoreCase(key)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u7684\u5143\u7d20\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ElementListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else if (BTNNEW.equalsIgnoreCase(key)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u7684\u5143\u7d20\u5206\u7c7b\u6682\u4e0d\u652f\u6301\u65b0\u589e\u5b50\u8282\u70b9\u3002", (String)"ElementListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        super.treeToolbarClick(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof New) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            IPageCache pageCache = this.getPageCache();
            pageCache.put(CURRENT_NODE, nodeId);
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode treeNode = root.getTreeNode(nodeId, 20);
            if (root == treeNode) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67d0\u4e2a\u5143\u7d20\u5206\u7c7b(\u8282\u70b9)\u540e\u518d\u65b0\u589e\u5143\u7d20\u3002", (String)"ElementListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void deleteRecord() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ElementListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = this.verifyElementReferenceBeforeDelete(listSelectedRows);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETE_REOCRD, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ElementListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    private String verifyElementReferenceBeforeDelete(ListSelectedRowCollection listSelectedRows) {
        Map<String, String> elementNumberNameMap = listSelectedRows.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v.getName()));
        QFilter filter = null;
        for (String number : elementNumberNameMap.keySet()) {
            String likeNumber = "%" + number + "%";
            if (filter == null) {
                filter = new QFilter("formula", "like", (Object)likeNumber);
                continue;
            }
            filter = filter.or(new QFilter("formula", "like", (Object)likeNumber));
        }
        DynamicObjectCollection elementObjectCollection = QueryServiceHelper.query((String)TDM_ELEMENT_GROUP, (String)"name,number,formula", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)elementObjectCollection)) {
            return "";
        }
        StringJoiner msg = new StringJoiner("\u3001");
        for (DynamicObject element : elementObjectCollection) {
            String number = element.getString("number");
            if (elementNumberNameMap.containsKey(number)) continue;
            String formula = element.getString("formula");
            List elementMapEntryList = elementNumberNameMap.entrySet().stream().filter(p -> formula.contains((CharSequence)p.getKey())).collect(Collectors.toList());
            String tipMsg = String.format("\u3010%s\u3011<--\u3010%s\u3011", String.join((CharSequence)",", elementMapEntryList.stream().map(p -> (String)p.getValue()).collect(Collectors.toList())), element.getString("name"));
            msg.add(tipMsg);
        }
        String result = msg.toString();
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return String.format(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u5143\u7d20\u5b58\u5728\u88ab\u5176\u4ed6\u5143\u7d20\u5f15\u7528\uff0c\u5f15\u7528\u5173\u7cfb\u4e3a\uff1a%1$s", (String)"ElementListPlugin_22", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), result);
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothingbaritemap1".equals(args.getOperateKey())) {
                this.showElementIndex();
            } else if ("donothingtbldisable".equals(args.getOperateKey())) {
                this.disable();
                this.refreshBillList();
            } else if ("donothingcopy".equals(args.getOperateKey())) {
                this.copy();
                this.refreshBillList();
            } else if ("donothingtbldel".equals(args.getOperateKey())) {
                this.deleteRecord();
            } else if ("elebizcheck".equals(args.getOperateKey())) {
                this.openBizCheckDialog();
            }
        }
        super.afterDoOperation(args);
    }

    private void openBizCheckDialog() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (listSelectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ElementListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)TDM_ELEMENT_GROUP);
            if ("1".equalsIgnoreCase(dynamicObject.getString("enable"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5143\u7d20\u3010%s\u3011\u672a\u542f\u7528\u3002", (String)"ElementListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object[]> customParams = new HashMap<String, Object[]>(8);
        customParams.put("ids", listSelectedRows.getPrimaryKeyValues());
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("tdm_ele_biz_check");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    private void copy() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ElementListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.copyCheck();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tdm_ele_copy_dailog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "copydailog"));
        this.getView().showForm(parameter);
    }

    private void copyCheck() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        for (ListSelectedRow lsr : list) {
            DynamicObject element = this.queryEleById(String.valueOf(lsr.getPrimaryKeyValue()));
            if (null == element.get("bottom") || element.getBoolean("bottom")) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5143\u7d20\u7f16\u7801\u3010%s\u3011\u4e0d\u662f\u5e95\u5c42\u5143\u7d20\u3002", (String)"ElementListPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), element.getString("number")));
        }
    }

    private void setUkName(DynamicObject copyElement) {
        String copyName = copyElement.getString("name");
        String selectFields = "id,name,number";
        QFilter codeFilter = new QFilter("name", "like", (Object)(copyName + "%"));
        DynamicObjectCollection sameNames = QueryServiceHelper.query((String)TDM_ELEMENT_GROUP, (String)selectFields, (QFilter[])new QFilter[]{codeFilter});
        if (EmptyCheckUtils.isEmpty((Object)sameNames)) {
            copyElement.set("name", (Object)String.format(ResManager.loadKDString((String)"%s-\u590d\u5236", (String)"ElementListPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), copyName));
        } else {
            List sameNameList = sameNames.stream().map(v -> v.getString("name")).collect(Collectors.toList());
            StringBuilder ukNameStr = new StringBuilder();
            ukNameStr.append(copyName);
            while (sameNameList.contains(ukNameStr.toString())) {
                ukNameStr.append(ResManager.loadKDString((String)"-\u590d\u5236", (String)"ElementListPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            copyElement.set("name", (Object)ukNameStr.toString());
        }
    }

    private void disable() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ElementListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow lsr : list) {
            if (this.doDisable(lsr)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5143\u7d20\u7f16\u7801\u3010%s\u3011\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u88ab\u7981\u7528\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ElementListPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), lsr.getNumber()));
            }
            ids.add(lsr.getPrimaryKeyValue());
        }
        QFilter codeFilter = new QFilter("id", "in", ids);
        DynamicObject[] elements = BusinessDataServiceHelper.load((String)TDM_ELEMENT_GROUP, (String)"id,enable,number", (QFilter[])new QFilter[]{codeFilter});
        if (EmptyCheckUtils.isEmpty((Object)elements)) {
            return;
        }
        for (DynamicObject element : elements) {
            String ableflag = element.getString("enable");
            if (BooleanEnum.NO.getCode().equalsIgnoreCase(ableflag)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5143\u7d20\u7f16\u7801\"%s\"\u5df2\u7981\u7528\u3002", (String)"ElementListPlugin_21", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), element.getString("number")));
                return;
            }
            element.set("enable", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject[])elements);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ElementListPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    public DynamicObject queryEleById(String elementid) {
        String selectFields = "name,number, status, enable,group, bottom, preset, json, json_tag, describe, timedeviationcount, timedeviationtype, timedeviationdirection, timedeviation, typevalue, autorefresh, isvariable, formulaname,risktimedeviationtype,  formula, gathercount, datatype, taxtype,draftpurpose,taxareagroup";
        QFilter codeFilter = new QFilter("id", "=", (Object)Long.parseLong(elementid));
        DynamicObject element = QueryServiceHelper.queryOne((String)TDM_ELEMENT_GROUP, (String)selectFields, (QFilter[])new QFilter[]{codeFilter});
        return element;
    }

    private boolean doDisable(ListSelectedRow lsr) {
        DynamicObject element = this.queryEleById(String.valueOf(lsr.getPrimaryKeyValue()));
        QFilter filter = new QFilter("json_tag", "like", (Object)("%" + element.get("number") + "%"));
        QFilter filter2 = new QFilter("bottom", "=", (Object)"0");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TDM_ELEMENT_GROUP, (String)"id,number,name,bottom", (QFilter[])new QFilter[]{filter, filter2});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return this.doDisableByRisk(element);
        }
        return true;
    }

    private boolean doDisableByRisk(DynamicObject element) {
        DynamicObjectCollection dynamicObjects;
        QFilter qFilter4;
        QFilter qFilter = new QFilter("json", "like", (Object)("%" + element.getString("number") + "%"));
        QFilter qFilter2 = new QFilter("entryentity.explain", "like", (Object)("%${" + element.getString("name") + "%"));
        qFilter.or(qFilter2);
        QFilter qFilter3 = new QFilter("entryentity.text", "like", (Object)("%" + element.getString("number") + "%"));
        DynamicObjectCollection bds = QueryServiceHelper.query((String)"tctrc_element_verify", (String)"id", (QFilter[])new QFilter[]{qFilter3});
        if (EmptyCheckUtils.isNotEmpty((Object)bds)) {
            List bdids = bds.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            qFilter4 = new QFilter("id", "in", bdids);
            qFilter.or(qFilter4);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(dynamicObjects = QueryServiceHelper.query((String)RISK_DEFINITION, (String)"id", (QFilter[])new QFilter[]{qFilter})))) {
            return true;
        }
        qFilter4 = new QFilter("json", "like", (Object)("%" + element.getString("number") + "%"));
        DynamicObjectCollection dynamicObjects2 = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id", (QFilter[])new QFilter[]{qFilter4});
        return EmptyCheckUtils.isNotEmpty((Object)dynamicObjects2);
    }

    private void showElementIndex() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ElementListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (list != null && list.size() > 20) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e0d\u80fd\u8d85\u8fc720\u6761\u3002", (String)"ElementListPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList result = new ArrayList();
        for (ListSelectedRow lsr : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", lsr.getNumber());
            map.put("name", lsr.getName());
            map.put("id", String.valueOf(lsr.getPrimaryKeyValue()));
            result.add(map);
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tdm_element_index_info");
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("elementindex", SerializationUtils.toJsonString(result));
        param.setCustomParams(customParams);
        StyleCss sc = new StyleCss();
        param.setCaption(ResManager.loadKDString((String)"\u5143\u7d20\u5f15\u7528\u8be6\u60c5", (String)"ElementListPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setInlineStyleCss(sc);
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData;
        boolean bottom;
        super.packageData(e);
        ColumnDesc source = (ColumnDesc)e.getSource();
        if (("timedeviationcount".equals(source.getKey()) || "datatype".equals(source.getKey())) && !(bottom = (rowData = e.getRowData()).getBoolean("bottom"))) {
            e.setFormatValue((Object)"");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (DELETE_REOCRD.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            ArrayList<Object> pkids = new ArrayList<Object>();
            for (ListSelectedRow selectedRow : listSelectedRows) {
                pkids.add(selectedRow.getPrimaryKeyValue());
            }
            QFilter qFilter = new QFilter("id", "in", pkids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TDM_ELEMENT_GROUP, (String)"number,enable,preset", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                if ("1".equalsIgnoreCase(dynamicObject.getString("enable"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\uff1a\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"ElementListPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), dynamicObject.get("number")));
                    return;
                }
                if (!"1".equalsIgnoreCase(dynamicObject.getString("preset"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u9884\u8bbe\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"ElementListPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), dynamicObject.get("number")));
                return;
            }
            DeleteServiceHelper.delete((String)TDM_ELEMENT_GROUP, (QFilter[])new QFilter[]{qFilter});
            String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ElementListPlugin_20", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ElementListPlugin_17", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            AppLogUtils.addLog((String)TDM_ELEMENT_GROUP, (String)opName, (String)opDesc);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ElementListPlugin_17", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        super.confirmCallBack(event);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("copydailog".equals(closedCallBackEvent.getActionId()) && null != closedCallBackEvent.getReturnData()) {
            String timedeviationtype = String.valueOf(closedCallBackEvent.getReturnData());
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(list.size());
            for (ListSelectedRow lsr : list) {
                DynamicObject element = this.queryEleById(String.valueOf(lsr.getPrimaryKeyValue()));
                DynamicObject copyElement = BusinessDataServiceHelper.newDynamicObject((String)TDM_ELEMENT_GROUP);
                BeanCopyUtils.copyDynamicObject((DynamicObject)element, (DynamicObject)copyElement);
                copyElement.set("id", null);
                copyElement.set("timedeviationtype", (Object)timedeviationtype);
                String timeDeviationType = copyElement.getString("timedeviationtype");
                String timeDeviationDirection = copyElement.getString("timedeviationdirection");
                String timeDeviationCount = copyElement.getString("timedeviationcount");
                Integer deviationCount = 0;
                if (StringUtils.isNumeric((CharSequence)timeDeviationCount)) {
                    deviationCount = Integer.valueOf(timeDeviationCount);
                }
                copyElement.set("timedeviation", (Object)TimeDeviatedEnum.getDeviatedDesc(timeDeviationDirection, deviationCount, timeDeviationType));
                copyElement.set("number", null);
                copyElement.set("preset", (Object)"0");
                String number = this.getUKNubmer(copyElement);
                this.setUkName(copyElement);
                copyElement.set("number", (Object)number);
                saveList.add(copyElement);
            }
            if (!saveList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            billlist.refresh();
        }
        super.closedCallBack(closedCallBackEvent);
    }

    private String getUKNubmer(DynamicObject copyElement) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber(TDM_ELEMENT_GROUP, copyElement, null);
        String number = codeRuleService.readNumber(TDM_ELEMENT_GROUP, copyElement, null);
        if (EmptyCheckUtils.isEmpty((Object)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u53bb\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"ElementListPlugin_18", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtil.contains((CharSequence)number, (CharSequence)ResManager.loadKDString((String)"\u968f\u673a\u7801", (String)"ElementListPlugin_19", (String)"taxc-tdm-formplugin", (Object[])new Object[0]))) {
            number = codeRuleService.getNumber(TDM_ELEMENT_GROUP, copyElement, null);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)TDM_ELEMENT_GROUP, (QFilter[])new QFilter[]{qFilter})) {
            return this.getUKNubmer(copyElement);
        }
        return number;
    }
}

