/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.DateClickListener;
import kd.bos.form.field.events.ResetDateFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class RdApportionPayEditPlugin
extends AbstractFormPlugin
implements DateClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(RdApportionPayEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        DateTimeEdit startDate = (DateTimeEdit)this.getControl("startdate");
        startDate.addDateClickListener((DateClickListener)this);
        BasedataEdit taxOrg = (BasedataEdit)this.getControl("taxorg");
        taxOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map sourceData : sourceDataList) {
            sourceData.put("datasource", "B");
            Object startDate = sourceData.get("startdate");
            if (startDate == null) break;
            try {
                Date parse = new SimpleDateFormat("yyyy-MM-dd").parse((String)startDate);
                Date endDate = this.getEndDate(parse);
                sourceData.put("enddate", endDate);
            }
            catch (ParseException e1) {
                logger.error(e1.getMessage());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("startdate".equals(name)) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (startDate == null) {
                this.getModel().setValue("enddate", null);
                return;
            }
            Date endDate = this.getEndDate(startDate);
            this.getModel().setValue("enddate", (Object)endDate);
        }
    }

    private Date getEndDate(Date startDate) {
        Calendar startCa = Calendar.getInstance();
        startCa.setTime(startDate);
        int startYear = startCa.get(1);
        int startMonth = startCa.get(2);
        Calendar endCa = Calendar.getInstance();
        endCa.set(1, startYear);
        endCa.set(2, startMonth + 1);
        int lastDay = endCa.getMinimum(5);
        endCa.set(5, lastDay - 1);
        return endCa.getTime();
    }

    public void resetDateFilter(ResetDateFilterEvent event) {
        int year = event.getFocusedYear();
        ArrayList<Date> list = new ArrayList<Date>(16);
        try {
            for (int i = 1; i <= 12; ++i) {
                list.add(DateFormat.getDateInstance().parse(year + "-" + i + "-1"));
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        event.setIncludeDates(list);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("taxorg".equals(name)) {
            Long currUserId = RequestContext.get().getCurrUserId();
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)currUserId);
            List data = (List)listTaxResult.getData();
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)data));
        }
    }
}

