/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.project.ProjectDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.basedata.BaseDataQueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RecordingImportPlugin
extends AbstractOperationServicePlugIn
implements IImportPlugin {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private static final String ORG_ENTITY = "tctb_org_entity";
    private static final String DATA_SOURCE = "datasource";
    private static final String SOURCE_SYS = "sourcesys";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        data.put(DATA_SOURCE, ResManager.loadKDString((String)"\u6a21\u677f\u5f15\u5165", (String)"RecordingImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        data.put(SOURCE_SYS, ResManager.loadKDString((String)"\u82cd\u7a79", (String)"RecordingImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        String accountName = (String)data.get("subaccount6");
        String isAdjust = (String)data.get("isadjust");
        if (EmptyCheckUtils.isEmpty((Object)accountName)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u79d1\u76ee\u540d\u79f0", (String)"RecordingImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        if (EmptyCheckUtils.isEmpty((Object)isAdjust)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u6574\u671f", (String)"RecordingImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return false;
        }
        if (EmptyCheckUtils.isEmpty((Object)data.get("org"))) {
            return super.beforeImportData(data, option, importlogs);
        }
        String orgNumber = (String)((Map)data.get("org")).get("number");
        Long orgId = this.orgMap.get(orgNumber);
        if (orgId == null) {
            QFilter qFilter = new QFilter("number", "=", (Object)orgNumber).and(new QFilter("fisaccounting", "=", (Object)"1"));
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (org != null) {
                orgId = org.getLong("id");
                this.orgMap.put(orgNumber, orgId);
            } else {
                importlogs.add(new ImportLogger.ImportLog(String.format("\u6838\u7b97\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", orgNumber)));
                return false;
            }
        }
        Map map = (Map)data.get("org");
        map.put("id", orgId);
        Map project = (Map)data.get("project");
        if (EmptyCheckUtils.isNotEmpty((Object)project)) {
            String projNumber = (String)project.get("number");
            DynamicObjectCollection orgBaseDatas = BaseDataQueryServiceHelper.queryBaseData((String)"bd_project", (Long)orgId, (QFilter)new QFilter("number", "=", (Object)projNumber), (String)"number");
            if (EmptyCheckUtils.isEmpty((Object)orgBaseDatas)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7ba1\u63a7\u7b56\u7565\u4e0b\u7ec4\u7ec7\u65e0\u8be5\u9879\u76ee\u6743\u9650\u3002", (String)"RecordingImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                return false;
            }
            TaxResult result = ProjectDataServiceHelper.validateProjectIsEnableAndStatusByProjectNumber((String)projNumber);
            boolean qualified = false;
            if (EmptyCheckUtils.isNotEmpty((Object)result) && result.isSuccess() && ((Boolean)result.getData()).booleanValue()) {
                qualified = true;
            }
            if (!qualified) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u9879\u76ee\u672a\u542f\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"RecordingImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                return false;
            }
        }
        String billNo = (String)data.get("billno");
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter numberFilter = new QFilter("number", "=", (Object)billNo);
        DynamicObject balance = BusinessDataServiceHelper.loadSingleFromCache((String)"tdm_account", (String)"id,name", (QFilter[])new QFilter[]{orgFilter, numberFilter});
        if (balance == null) {
            importlogs.add(new ImportLogger.ImportLog(String.format("\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u79d1\u76ee\u7f16\u7801 # billno \u201c%s\u201d", billNo)));
            return false;
        }
        balanceMap.put("id", balance.get("id"));
        data.put("balance", balanceMap);
        data.put("subaccount6", balance.get("name"));
        String debitLocalCurrency = (String)data.get("debitlocalcurrency");
        String creditLocalCurrency = (String)data.get("creditlocalcurrency");
        if (StringUtil.isAllBlank((CharSequence[])new CharSequence[]{debitLocalCurrency, creditLocalCurrency})) {
            importlogs.add(new ImportLogger.ImportLog("\u540c\u4e00\u884c\u6570\u636e\u501f\u65b9\u91d1\u989d\u548c\u8d37\u65b9\u91d1\u989d\u9700\u5f55\u5165\u4e00\u9879\uff0c\u8bf7\u4fee\u6539"));
            return false;
        }
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{debitLocalCurrency, creditLocalCurrency})) {
            importlogs.add(new ImportLogger.ImportLog("\u540c\u4e00\u884c\u6570\u636e\uff0c\u501f\u65b9\u91d1\u989d\u548c\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\uff0c\u8bf7\u4fee\u6539"));
            return false;
        }
        if ("new".equals(option.get("importtype"))) {
            String voucherCode = (String)data.get("vouchercode");
            Date voucherDate = DateUtils.stringToDate((String)((String)data.get("voucherdate")));
            String voucherType = (String)data.get("vouchertype");
            String voucherRow = (String)data.get("voucherrow");
            QFilter voucherCodeFilter = new QFilter("vouchercode", "=", (Object)voucherCode);
            QFilter voucherDateFilter = new QFilter("voucherdate", "=", (Object)voucherDate);
            QFilter voucherTypeFilter = new QFilter("vouchertype", "=", (Object)voucherType);
            QFilter voucherRowFilter = new QFilter("voucherrow", "=", (Object)voucherRow);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(voucherCodeFilter);
            qFilterList.add(voucherDateFilter);
            qFilterList.add(voucherTypeFilter);
            qFilterList.add(voucherRowFilter);
            qFilterList.add(orgFilter);
            QFilter[] qFilterArray = new QFilter[qFilterList.size()];
            qFilterList.toArray(qFilterArray);
            boolean voucherExist = QueryServiceHelper.exists((String)"tdm_recording_voucher_new", (QFilter[])qFilterArray);
            if (voucherExist) {
                importlogs.add(new ImportLogger.ImportLog("\u51ed\u8bc1\u6570\u636e\u91cd\u590d\uff0c\u5982\u9700\u66f4\u65b0\u6570\u636e\uff0c\u5f15\u5165\u65f6\u8bf7\u9009\u62e9\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u6216\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e"));
                return false;
            }
            BigDecimal noWriteOff = BigDecimal.ZERO;
            if (EmptyCheckUtils.isNotEmpty((Object)debitLocalCurrency)) {
                noWriteOff = noWriteOff.add(new BigDecimal(debitLocalCurrency));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)creditLocalCurrency)) {
                noWriteOff = noWriteOff.add(new BigDecimal(creditLocalCurrency));
            }
            data.put("nowriteoff", String.valueOf(noWriteOff));
        }
        return super.beforeImportData(data, option, importlogs);
    }
}

