/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tdm.common.enums.DateControlEnum;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class RecordingVoucherListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ListDataProvider list = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                return super.getData(start, limit);
            }
        };
        ListUserOption user = new ListUserOption();
        user.setMaxReturnData(1000000000);
        list.setListUserOption(user);
        args.setListDataProvider((IListDataProvider)list);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (EmptyCheckUtils.isEmpty((Object)args.getFilterValue("kjnd"))) {
            return;
        }
        String selScope = (String)((List)args.getFilterValue("kjnd")).get(0);
        if (!DateControlEnum.isDateConst((String)selScope)) {
            return;
        }
        this.getPageCache().put("isDateConst", "1");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist;
        boolean isAfterConfirm;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("donothingdelete".equals(operationKey) && !(isAfterConfirm = operate.getOption().tryGetVariableValue("afterconfirm", new RefObject())) && (billlist = (BillList)this.getControl("billlistap")) != null) {
            if (billlist.getSelectedRows() != null && billlist.getSelectedRows().size() > 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u51ed\u8bc1\u7f16\u53f7\u7684\u884c\u6570\u636e\u5c06\u4e00\u5e76\u5220\u9664\uff0c\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u201c%d\u201d\u6761\u8bb0\u5f55\u5bf9\u5e94\u7684\u51ed\u8bc1\u5417\uff1f", (String)"RecordingVoucherListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), billlist.getSelectedRows().size()), MessageBoxOptions.YesNo, confirmCallBackListener);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RecordingVoucherListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "donothingdelete".equals(args.getOperateKey())) {
            this.deleteData();
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.clearSelection();
            billlist.refreshData();
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"delete", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("donothingdelete", operateOption);
        }
    }

    private void deleteData() {
        BillList billlist = (BillList)this.getControl("billlistap");
        Object[] pkIds = billlist.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)pkIds);
        ArrayList orgIds = new ArrayList();
        ArrayList voucherCodes = new ArrayList();
        ArrayList accountYear = new ArrayList();
        ArrayList accountPeriod = new ArrayList();
        ArrayList voucherTypes = new ArrayList();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_recording_voucher_new", (String)"org,vouchercode,accountperiod,accountyear,vouchertype", (QFilter[])new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects.stream().forEach(o -> {
                orgIds.add(o.getLong("org"));
                voucherCodes.add(o.getString("vouchercode"));
                accountPeriod.add(o.getString("accountperiod"));
                accountYear.add(o.getString("accountyear"));
                voucherTypes.add(o.getString("vouchertype"));
            });
            qFilter = new QFilter("org", "in", orgIds).and(new QFilter("vouchercode", "in", voucherCodes).and(new QFilter("vouchertype", "in", voucherTypes)).and(new QFilter("accountyear", "in", accountYear)).and(new QFilter("accountperiod", "in", accountPeriod)));
        }
        DeleteServiceHelper.delete((String)"tdm_recording_voucher_new", (QFilter[])new QFilter[]{qFilter});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RecordingVoucherListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    public void setFilter(SetFilterEvent e) {
        List qFilterList = e.getQFilters();
        ArrayList<QFilter> newList = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)qFilterList)) {
            Date year0 = new Date();
            Date year1 = new Date();
            boolean haveKjnd = false;
            Iterator iterator = qFilterList.iterator();
            while (iterator.hasNext()) {
                QFilter filter = (QFilter)iterator.next();
                if (!filter.getProperty().equals("kjnd")) continue;
                year0 = (Date)filter.recombine()[0].getValue();
                year1 = (Date)filter.recombine()[1].getValue();
                haveKjnd = true;
                iterator.remove();
            }
            if (!haveKjnd) {
                return;
            }
            ArrayList<String> years = new ArrayList<String>();
            String begin = null;
            String end = null;
            if (year0.before(year1)) {
                Date firstDay;
                begin = DateUtils.format((Date)year0, (String)"yyyy");
                end = DateUtils.format((Date)year1, (String)"yyyy");
                if (Integer.parseInt(begin) < Integer.parseInt(end) && (firstDay = DateUtils.getFirstDateOfYear((Date)year1)).compareTo(year1) >= 0) {
                    end = String.valueOf(Integer.parseInt(end) - 1);
                }
            } else {
                begin = DateUtils.format((Date)year1, (String)"yyyy");
                end = DateUtils.format((Date)year0, (String)"yyyy");
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get("isDateConst"), (CharSequence)"1")) {
                years.add(begin);
                this.getPageCache().remove("isDateConst");
            } else {
                while (Integer.parseInt(begin) <= Integer.parseInt(end)) {
                    years.add(begin);
                    begin = String.valueOf(Integer.parseInt(begin) + 1);
                }
            }
            newList.add(new QFilter("accountyear", "in", years));
            qFilterList.addAll(newList);
            e.setOrderBy(" ");
        }
    }
}

