/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ShipTaxFundInfoPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        if (org != null && dataEntity.get("taxauthority") == null) {
            this.setTaxOfficeVal(org.getLong("id"));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        TaxResult result;
        Map sourceData = args.getSourceData();
        JSONObject org = (JSONObject)sourceData.get("orgfield");
        if (org != null && (result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number"))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            JSONObject taxoffice = new JSONObject();
            taxoffice.put("importprop", (Object)"id");
            taxoffice.put("id", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
            sourceData.put("taxauthority", taxoffice);
        }
    }

    private void setTaxOfficeVal(Long orgid) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            this.getModel().setValue("taxauthority", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date jmend;
        String name = e.getProperty().getName();
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int focusRow = entryentity.getEntryState().getFocusRow();
        if ("start".equals(name)) {
            Date jmstart = (Date)this.getModel().getValue("start", focusRow);
            if (jmstart != null && !jmstart.equals(DateUtils.getFirstDateOfYear((Date)jmstart))) {
                this.getModel().setValue("start", (Object)DateUtils.getFirstDateOfYear((Date)jmstart), focusRow);
                return;
            }
        } else if ("end".equals(name) && (jmend = (Date)this.getModel().getValue("end", focusRow)) != null && !jmend.equals(DateUtils.getLastDateOfYear((Date)jmend))) {
            this.getModel().setValue("end", (Object)DateUtils.getLastDateOfYear((Date)jmend), focusRow);
            return;
        }
    }
}

