/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tdm.common.util.PermissionUtils;
import org.apache.commons.collections.CollectionUtils;

public class TotalAssetsMesListPlugin
extends AbstractListPlugin {
    private static final String TOOLBARAP = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String ASSETSTYPEBN = "assetstypebn";
    private static final String YEARITEMS = "tpo_yearitems_tree";
    private static final String SWZCLB = "swzclb";
    private static final List<String> ptNumbers = Lists.newArrayList((Object[])new String[]{"701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "701020201", "701020202", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "701020401", "701020402", "701020403", "701020404", "701020405", "701020501", "701020502"});

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn;
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            typeColumn = (CommonFilterColumn)column;
            typeColumn.setDefaultValue(this.getDefaultOrgId());
        }
        for (FilterColumn column : schemeColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            typeColumn = (SchemeFilterColumn)column;
            typeColumn.setDefaultValue(this.getDefaultOrgId());
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
    }

    private String getDefaultOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        if (orgId == null) {
            orgId = PermissionUtils.getDefaultOrgId();
        }
        return orgId != null ? String.valueOf(orgId) : "0";
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (SWZCLB.equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"TotalAssetsMesListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)YEARITEMS, (boolean)false, (int)0);
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u578b\u9009\u62e9", (String)"TotalAssetsMesListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            List filters = showParameter.getListFilterParameter().getQFilters();
            QFilter numberFilter = new QFilter("number", "in", ptNumbers);
            filters.add(numberFilter);
            Map customParams = showParameter.getCustomParams();
            customParams.put("type", "zcajust");
            customParams.put("ptNumbers", ptNumbers);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectNumbers"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData;
        String actionId = evt.getActionId();
        if ("selectNumbers".equals(actionId) && null != (returnData = (ListSelectedRowCollection)evt.getReturnData())) {
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            Object[] keys = list.getPrimaryKeyValues();
            DynamicObject[] totalassetsMes = BusinessDataServiceHelper.load((Object[])keys, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_totalassets_mes"));
            Arrays.stream(totalassetsMes).forEach(i -> i.set("taxassetstype", primaryKeyValue));
            SaveServiceHelper.update((DynamicObject[])totalassetsMes);
            billlist.clearSelection();
            billlist.refresh();
        }
    }
}

