/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.common.util.TreeUtils;

public class WithholdingBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String BOS_ORG = "bos_org";
    private static final String TAXPAYERNAME = "taxpayername";
    private static final String TAXPAYERNUMBER = "taxpayernumber";
    private static final String TAXOFFICE = "officetax";
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String ORG = "org";
    private static final String ACTUALPAYMENT = "actualpayment";
    private static final String AMOUNT = "amount";
    private static final String WITHHOLDINGITEMS = "withholdingitems";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(ORG);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Boolean> heightLimit = new HashMap<String, Boolean>();
        heightLimit.put("heightLimit", false);
        this.getView().updateControlMetadata(WITHHOLDINGITEMS, heightLimit);
        long orgId = RequestContext.get().getOrgId();
        QFilter f = new QFilter("id", "=", (Object)orgId);
        DynamicObject istax = QueryServiceHelper.queryOne((String)BOS_ORG, (String)"fistax", (QFilter[])new QFilter[]{f});
        boolean istaxpayer = (Boolean)TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgIdAndIsTaxpayer((Long)orgId).getData();
        if (istax != null && istax.getBoolean(0) && istaxpayer) {
            this.getModel().setValue(ORG, (Object)orgId);
            this.setTaxInfo(orgId);
        } else {
            QFilter f2;
            QFilter f1;
            DynamicObjectCollection taxOrgs;
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"47156aff000000ac");
            boolean isAllPermOrgs = allPermOrgs.hasAllOrgPerm();
            if (!isAllPermOrgs && (taxOrgs = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{f1 = this.taxOrgPermission(allPermOrgs), f2 = new QFilter("istaxpayer", "=", (Object)"1")})).size() != 0) {
                orgId = ((DynamicObject)taxOrgs.get(0)).getLong(0);
                this.getModel().setValue(ORG, (Object)orgId);
                this.setTaxInfo(orgId);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equalsIgnoreCase(name)) {
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"47156aff000000ac");
            boolean isAllPermOrgs = allPermOrgs.hasAllOrgPerm();
            if (!isAllPermOrgs) {
                QFilter f1 = this.taxOrgPermission(allPermOrgs);
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getTreeFilterParameter().getQFilters().add(f1);
                showParameter.getListFilterParameter().setFilter(f1);
            } else {
                DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)allPermOrgs, (boolean)true);
                if (null != col && !col.isEmpty()) {
                    List orgList = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    QFilter f1 = new QFilter("id", "in", orgList);
                    List<Long> orgIds = this.taxFilterCondition(f1);
                    QFilter f4 = new QFilter("id", "in", orgIds);
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    showParameter.getTreeFilterParameter().getQFilters().add(f4);
                    showParameter.getListFilterParameter().setFilter(f4);
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Object org = this.getModel().getValue(ORG);
        if (org == null) {
            this.getModel().setValue(TAXPAYERNAME, null);
            this.getModel().setValue(TAXPAYERNUMBER, null);
            this.getModel().setValue(TAXOFFICE, null);
        } else {
            Object orgId = afterF7SelectEvent.getInputValue();
            orgId = orgId == null ? afterF7SelectEvent.getListSelectedRow().getPrimaryKeyValue() : Long.valueOf(orgId.toString());
            this.setTaxInfo((Long)orgId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)ACTUALPAYMENT, (CharSequence)propertyName)) {
            this.calcAmountMethod();
        }
        super.propertyChanged(e);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (WITHHOLDINGITEMS.equals(entryName)) {
            this.calcAmountMethod();
        }
    }

    private QFilter taxOrgPermission(HasPermOrgResult allPermOrgs) {
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        QFilter f1 = new QFilter("id", "in", (Object)hasPermOrgs);
        List<Long> orgIds = this.taxFilterCondition(f1);
        return new QFilter("id", "in", orgIds);
    }

    private List<Long> taxFilterCondition(QFilter f1) {
        QFilter f2 = new QFilter("istaxpayer", "=", (Object)"1").and(f1);
        QFilter f3 = new QFilter("status", "=", (Object)"1").and(f2);
        DynamicObjectCollection hasPermOrgsCollection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{f3});
        List<Long> orgIds = hasPermOrgsCollection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        return orgIds;
    }

    private void calcAmountMethod() {
        EntryGrid entry = (EntryGrid)this.getControl(WITHHOLDINGITEMS);
        BigDecimal sum = entry.getSum(ACTUALPAYMENT);
        entry.summary();
        this.getModel().setValue(AMOUNT, (Object)sum);
    }

    private void setTaxInfo(Long orgId) {
        DynamicObject taxofficeObject;
        QFilter f1 = new QFilter("id", "=", (Object)orgId);
        QFilter f2 = new QFilter("taxorg", "=", (Object)orgId);
        DynamicObject taxpayerObject = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)"taxpayer as taxpayername,unifiedsocialcode as taxpayernumber", (QFilter[])new QFilter[]{f1});
        if (null != taxpayerObject) {
            if (taxpayerObject.getString(TAXPAYERNAME).equals("") && taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u540d\u79f0\u548c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"WithholdingBillPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TAXPAYERNAME, (Object)"");
                this.getModel().setValue(TAXPAYERNUMBER, (Object)"");
            } else {
                this.getModel().setValue(TAXPAYERNAME, (Object)taxpayerObject.getString(TAXPAYERNAME));
                this.getModel().setValue(TAXPAYERNUMBER, (Object)taxpayerObject.getString(TAXPAYERNUMBER));
            }
            if (taxpayerObject.getString(TAXPAYERNAME).equals("") && !taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u540d\u79f0\u3002", (String)"WithholdingBillPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TAXPAYERNAME, (Object)"");
            } else {
                this.getModel().setValue(TAXPAYERNAME, (Object)taxpayerObject.getString(TAXPAYERNAME));
            }
            if (!taxpayerObject.getString(TAXPAYERNAME).equals("") && taxpayerObject.getString(TAXPAYERNUMBER).equals("")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"WithholdingBillPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TAXPAYERNUMBER, (Object)"");
            } else {
                this.getModel().setValue(TAXPAYERNUMBER, (Object)taxpayerObject.getString(TAXPAYERNUMBER));
            }
        }
        if (null != (taxofficeObject = QueryServiceHelper.queryOne((String)TCTB_TAX_MAIN, (String)"taxoffice as officetax", (QFilter[])new QFilter[]{f2}))) {
            this.getModel().setValue(TAXOFFICE, (Object)taxofficeObject.getString(TAXOFFICE));
        }
    }
}

