/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.formplugin.constant.InvoiceSubEntityMappingEnum;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class WithholdingImportPlugin
implements IImportPlugin {
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private String entryEntityName = null;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray entities;
        String orgNumber = (String)((Map)data.get("org")).get("number");
        Long orgId = this.orgMap.get(orgNumber);
        if (orgId == null) {
            DynamicObjectCollection col = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("number", orgNumber));
            if (col != null && col.size() > 0) {
                orgId = ((DynamicObject)col.get(0)).getLong("id");
                if (orgId == 0L) {
                    importlogs.add(new ImportLogger.ImportLog(String.format("\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", orgNumber)));
                    return false;
                }
                this.orgMap.put(orgNumber, orgId);
            } else {
                importlogs.add(new ImportLogger.ImportLog(String.format("\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", orgNumber)));
                return false;
            }
        }
        data.put("datasource", "2");
        data.put("billno", String.valueOf(data.get("taxcode")));
        data.put("period", DateUtils.stringToDate((String)((String)data.get("period")), (String)"yyyy-MM"));
        data.put("sourcesys", ResManager.loadKDString((String)"\u82cd\u7a79", (String)"WithholdingImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)this.entryEntityName) && (entities = (JSONArray)data.get(this.entryEntityName)).size() == 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("seq", (Object)1);
            entities.add((Object)jsonObject);
            data.put(this.entryEntityName, entities);
        }
        return super.beforeImportData(data, option, importlogs);
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return super.importData(data, option, importlogs);
    }

    public BillEntityType getImportMainEntityType(String billFormId) {
        this.entryEntityName = null;
        this.entryEntityName = InvoiceSubEntityMappingEnum.getSubEntityNameByEntityName(billFormId);
        return super.getImportMainEntityType(billFormId);
    }
}

