/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.common.util.BaseDataUtil;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class WithholdingListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs contInitEvent) {
        super.filterContainerInit(contInitEvent);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List dateList = new ArrayList();
        List orgs = new ArrayList();
        List signdateList = new ArrayList();
        if (null != customParams.get("period")) {
            dateList = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("period")), List.class);
        }
        if (null != customParams.get("signdate")) {
            signdateList = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("signdate")), List.class);
        }
        if (null != customParams.get("orgs")) {
            orgs = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("orgs")), List.class);
        }
        List commonFilters = contInitEvent.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if ("period".equalsIgnoreCase(fieldName) && !dateList.isEmpty()) {
                filterColumn.setDefaultValues(dateList);
            }
            if ("signdate".equalsIgnoreCase(fieldName) && !dateList.isEmpty()) {
                filterColumn.setDefaultValues(signdateList);
            }
            if (!fieldName.startsWith("org.")) continue;
            if (!orgs.isEmpty()) {
                filterColumn.setDefaultValues(orgs.stream().map(s -> s.toString()).collect(Collectors.toList()));
                continue;
            }
            filterColumn.setDefaultValues(new Object[]{BaseDataUtil.getDefaultOrg((IFormView)this.getView())});
        }
    }

    public void setFilter(SetFilterEvent e) {
        HasPermOrgResult hasPermOrgResult;
        Optional<QFilter> orgOptional;
        QFilter oldQFilter;
        QFilter[] arrQFilter;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> optional = qFilters.stream().filter(s -> "period".equals(s.getProperty())).findFirst();
        if (optional.isPresent() && (arrQFilter = (oldQFilter = optional.get()).recombine()).length >= 2) {
            Date start = (Date)arrQFilter[0].getValue();
            Date end = (Date)arrQFilter[1].getValue();
            qFilters.remove(oldQFilter);
            if (WithholdingListPlugin.sameMonth(start, end)) {
                qFilters.add(new QFilter("period", "=", (Object)DateUtils.getFirstDateOfMonth((Date)start)));
            } else {
                QFilter newQFilter = new QFilter("period", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)start)).and(new QFilter("period", "<", (Object)DateUtils.getFirstDateOfMonth((Date)end)));
                qFilters.add(newQFilter);
            }
            for (int i = 2; i < arrQFilter.length; ++i) {
                ((QFilter)qFilters.get(0)).and(arrQFilter[i]);
            }
        }
        if (!(orgOptional = qFilters.stream().filter(s -> s.getProperty().startsWith("org.")).findFirst()).isPresent() && EmptyCheckUtils.isNotEmpty((Object)(hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView()))) && !hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            qFilters.add(new QFilter("org.id", "in", (Object)orgList));
        }
    }

    private static boolean sameMonth(Date start, Date end) {
        return DateUtils.formatMonth((Date)start).equals(DateUtils.formatMonth((Date)end));
    }
}

