/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.apphome;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class AssetsDataCardPlugin
extends AbstractFormPlugin {
    private static final String ORG = "org";
    private static final String ORGS = "orgs";
    private static final String TAXORG = "taxorg";
    private static final String END_DATE = "enddate";
    private static final String START_DATE = "startdate";
    private static final String TOTAL_VALUE = "totalvalue";
    private static final String CLEANINGDATE = "cleaningdate";
    private static final String ACCOUNTINGPERIOD = "accountingperiod";
    private static final String AMOUNT_VALUE = "amountvalue";
    private static final String TAXCURRENTAMOUNT = "taxcurrentamount";
    private static final String TDM_ASSET_DATA = "tdm_asset_data";
    private static final String TDM_TAX_DEPRECIATION = "tdm_tax_depreciation";
    private IPageCache parentPageCache;

    public void afterCreateNewData(EventObject e) {
        String orgs = this.getParentPageCache().get(ORGS);
        String startDateStr = this.getParentPageCache().get(START_DATE);
        String endDateStr = this.getParentPageCache().get(END_DATE);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{orgs, startDateStr, endDateStr})) {
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            Date startDate = DateUtils.stringToDate((String)startDateStr);
            Date startTime = DateUtils.getFirstDateOfMonth((Date)startDate);
            Date endDate = DateUtils.stringToDate((String)endDateStr);
            endDate = DateUtils.addMonth((Date)endDate, (int)1);
            Date endTime = DateUtils.getFirstDateOfMonth((Date)endDate);
            this.setAssetsCount(orgList, endTime);
            this.setAssetsAmount(orgList, startTime, endTime);
        }
    }

    private void setAssetsAmount(List<Long> orgList, Date startTime, Date endTime) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgList.toArray());
        QFilter startFilter = new QFilter(ACCOUNTINGPERIOD, ">=", (Object)startTime);
        QFilter endFilter = new QFilter(ACCOUNTINGPERIOD, "<", (Object)endTime);
        DataSet assetsColDataSet = QueryServiceHelper.queryDataSet((String)"AssetsDataCardPlugin_setAssetsAmount", (String)TDM_TAX_DEPRECIATION, (String)"id,taxcurrentamount", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}, null);
        for (Row row : assetsColDataSet) {
            totalAmount = totalAmount.add(row.getBigDecimal(TAXCURRENTAMOUNT));
        }
        assetsColDataSet.close();
        BigDecimal amount = totalAmount.setScale(2, 4);
        Label amountValue = (Label)this.getControl(AMOUNT_VALUE);
        amountValue.setText(String.valueOf(amount));
    }

    private void setAssetsCount(List<Long> orgList, Date endTime) {
        QFilter orgFilter = new QFilter(TAXORG, "in", (Object)orgList.toArray());
        QFilter cleaningdateFilter = new QFilter(CLEANINGDATE, "is null", null);
        QFilter startFilter = new QFilter(START_DATE, "<", (Object)endTime);
        DataSet assetsColDataSet = QueryServiceHelper.queryDataSet((String)"AssetsDataCardPlugin_setAssetsCount", (String)TDM_ASSET_DATA, (String)"id", (QFilter[])new QFilter[]{orgFilter, startFilter, cleaningdateFilter}, null);
        Label assetsValue = (Label)this.getControl(TOTAL_VALUE);
        assetsValue.setText(String.valueOf(assetsColDataSet.count("id", false)));
        assetsColDataSet.close();
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }
}

