/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class FinanceDataCardPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(FinanceDataCardPlugin.class);
    private static final String ORG = "org";
    private static final String ORGS = "orgs";
    private static final String SKSSQQ = "skssqq";
    private static final String END_DATE = "enddate";
    private static final String START_DATE = "startdate";
    private static final String VOUCHER_DATE = "voucherdate";
    private static final String VOUCHER_VALUE = "vouchervalue";
    private static final String BALANCE_VALUE = "balancevalue";
    private static final String FINANCE_VALUE = "financevalue";
    private static final String ACCOUNT_CYCLE = "accountcycle";
    private static final String TDM_BALANCE_NEW = "tdm_balance_new";
    private static final String TDM_FINANCE_MAIN = "tdm_finance_main";
    private static final String TDM_RECORDING_VOUCHER_NEW = "tdm_recording_voucher_new";
    private IPageCache parentPageCache;

    public void afterCreateNewData(EventObject e) {
        String orgs = this.getParentPageCache().get(ORGS);
        String startDateStr = this.getParentPageCache().get(START_DATE);
        String endDateStr = this.getParentPageCache().get(END_DATE);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{orgs, startDateStr, endDateStr})) {
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            Date startDate = DateUtils.stringToDate((String)startDateStr);
            Date endDate = DateUtils.stringToDate((String)endDateStr);
            int voucherTotal = this.getVoucherTotal(orgList, startDate, endDate);
            Label voucherValue = (Label)this.getControl(VOUCHER_VALUE);
            voucherValue.setText(String.valueOf(voucherTotal));
            int balanceTotal = this.getBlanceTotal(orgList, startDate, endDate);
            Label banlanceValue = (Label)this.getControl(BALANCE_VALUE);
            banlanceValue.setText(String.valueOf(balanceTotal));
            int financeTotal = this.getFinanceTotal(orgList, startDate, DateUtils.addMonth((Date)endDate, (int)1));
            Label financeValue = (Label)this.getControl(FINANCE_VALUE);
            financeValue.setText(String.valueOf(financeTotal));
        }
    }

    private int getFinanceTotal(List<Long> orgList, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgList.toArray());
        QFilter startFilter = new QFilter(SKSSQQ, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)startDate));
        QFilter endFilter = new QFilter(SKSSQQ, "<", (Object)DateUtils.getFirstDateOfMonth((Date)endDate));
        DataSet financeColDataSet = QueryServiceHelper.queryDataSet((String)"FinanceDataCardPlugin.getFinanceTotal", (String)TDM_FINANCE_MAIN, (String)"id", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}, null);
        int size = financeColDataSet.count("id", false);
        financeColDataSet.close();
        return size;
    }

    private int getBlanceTotal(List<Long> orgList, Date startDate, Date endDate) {
        QFilter filter = new QFilter(ORG, "in", orgList);
        QFilter datefilter = this.getMouthDateFilter(startDate, endDate);
        filter.and(datefilter);
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)"FinanceDataCardPlugin_getBlanceTotal", (String)TDM_BALANCE_NEW, (String)"id", (QFilter[])new QFilter[]{filter}, null);
        int balanceCol = balanceDataSet.count("id", false);
        balanceDataSet.close();
        return balanceCol;
    }

    private QFilter getMouthDateFilter(Date startDate, Date endDate) {
        List dateBetween = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
        if (dateBetween.size() <= 0) {
            return null;
        }
        String datestr = (String)dateBetween.get(0);
        QFilter datefilter = new QFilter("accountyear", "=", (Object)datestr.substring(0, 4)).and(new QFilter("accountperiod", "=", (Object)datestr.substring(5)));
        for (int i = 1; i < dateBetween.size(); ++i) {
            datestr = (String)dateBetween.get(i);
            QFilter itemfilter = new QFilter("accountyear", "=", (Object)datestr.substring(0, 4)).and(new QFilter("accountperiod", "=", (Object)datestr.substring(5)));
            datefilter.or(itemfilter);
        }
        return datefilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getVoucherTotal(List<Long> orgList, Date startDate, Date endDate) {
        QFilter filter = new QFilter(ORG, "in", orgList);
        QFilter datefilter = this.getMouthDateFilter(startDate, endDate);
        filter.and(datefilter);
        int result = 0;
        try (DataSet voucherColDataSet = QueryServiceHelper.queryDataSet((String)"FinanceDataCardPlugin_getVoucherTotal", (String)TDM_RECORDING_VOUCHER_NEW, (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            result = voucherColDataSet.count("id", false);
        }
        return result;
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }
}

