/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.constant.InputInvoiceSelectFieldEnum;

public class InvoiceDataCardPlugin
extends AbstractFormPlugin {
    private static final String ORG = "taxorg";
    private static final String TAX_ORG = "tax_org";
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String OUTPUT_VALUE = "outputvalue";
    private static final String INPUT_VALUE = "inputvalue";
    private static final String INVOICE_DATE = "issuetime";
    private static final String INVOICE_STATUS = "invoicestatus";
    private static final String TDM_INVOICE_OUTPUT = "sim_vatinvoice";
    private IPageCache parentPageCache;

    public void afterCreateNewData(EventObject e) {
        String orgs = this.getParentPageCache().get(ORGS);
        String startDateStr = this.getParentPageCache().get(START_DATE);
        String endDateStr = this.getParentPageCache().get(END_DATE);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{orgs, startDateStr, endDateStr})) {
            ORM orm = ORM.create();
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            Date startDate = DateUtils.stringToDate((String)startDateStr);
            Date endDate = DateUtils.stringToDate((String)endDateStr);
            int outputTotal = this.getOutputTotal(orgList, startDate, DateUtils.addMonth((Date)endDate, (int)1), orm);
            Label outputValue = (Label)this.getControl(OUTPUT_VALUE);
            outputValue.setText(String.valueOf(outputTotal));
            int inputTotal = this.getInputTotal(orgList, startDate, DateUtils.addMonth((Date)endDate, (int)1), orm);
            Label intpuValue = (Label)this.getControl(INPUT_VALUE);
            intpuValue.setText(String.valueOf(inputTotal));
        }
    }

    private int getInputTotal(List<Long> orgList, Date startDate, Date endDate, ORM orm) {
        int total = 0;
        for (InputInvoiceSelectFieldEnum entry : InputInvoiceSelectFieldEnum.values()) {
            String entityName = entry.getEntityName();
            String periodField = entry.getPeriodField();
            String orgField = entry.getOrgField();
            QFilter orgFilter = new QFilter(orgField, "in", (Object)orgList.toArray());
            QFilter startFilter = new QFilter(periodField, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)startDate));
            QFilter endFilter = new QFilter(periodField, "<", (Object)DateUtils.getFirstDateOfMonth((Date)endDate));
            QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter};
            int count = InvoiceDataCardPlugin.count(((Object)((Object)this)).getClass().getName(), entityName, "id", filters);
            total += count;
        }
        return total;
    }

    private int getOutputTotal(List<Long> orgList, Date startDate, Date endDate, ORM orm) {
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgList.toArray());
        QFilter startFilter = new QFilter(INVOICE_DATE, ">=", (Object)DateUtils.getFirstDateOfMonth((Date)startDate));
        QFilter endFilter = new QFilter(INVOICE_DATE, "<", (Object)DateUtils.getFirstDateOfMonth((Date)endDate));
        QFilter statusFilter = new QFilter(INVOICE_STATUS, "=", (Object)"0");
        int count = orm.count(((Object)((Object)this)).getClass().getName(), TDM_INVOICE_OUTPUT, "id", new QFilter[]{orgFilter, startFilter, endFilter, statusFilter});
        return count;
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }

    private static int count(String name, String entityName, String fields, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count(name, entityName, fields, filters);
    }
}

