/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.apphome;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.constant.InputInvoiceSelectFieldEnum;

public class InvoiceTaxTrendCardPlugin
extends AbstractFormPlugin {
    private static final String POSITION_VALUE = "40px";
    private static final String ORG = "taxorg";
    private static final String TAX_ORG = "tax_org";
    private static final String ORGS = "orgs";
    private static final String END_DATE = "enddate";
    private static final String START_DATE = "startdate";
    private static final String INVOICE_STATUS = "invoicestatus";
    private static final String INVOICE_DATE = "issuetime";
    private static final String TAX_AMOUNT = "totaltax";
    private static final String POINTLINE_CHARTAP = "pointlinechartap";
    private static final String TDM_INVOICE_OUTPUT = "sim_vatinvoice";
    private static final String OUTPUR_SELECTFIELDS = "id,totaltax,issuetime";
    private static final Map<String, String> RMB_UNIT = new HashMap<String, String>();
    private IPageCache parentPageCache;

    public void registerListener(EventObject e) {
        PointLineChart chart = (PointLineChart)this.getControl(POINTLINE_CHARTAP);
        chart.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String orgs = this.getParentPageCache().get(ORGS);
        String startDateStr = this.getParentPageCache().get(START_DATE);
        String endDateStr = this.getParentPageCache().get(END_DATE);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{orgs, startDateStr, endDateStr})) {
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            Date startDate = DateUtils.stringToDate((String)startDateStr);
            Date endDate = DateUtils.stringToDate((String)endDateStr);
            Map<String, BigDecimal> outputAmountMap = this.getOutputAmount(orgList, startDate, endDate);
            Map<String, BigDecimal> inputAmountMap = this.getInputAmount(orgList, startDate, endDate);
            this.drawChart(outputAmountMap, inputAmountMap);
        }
    }

    private Map<String, BigDecimal> getInputAmount(List<Long> orgList, Date startDate, Date endDate) {
        Map<String, BigDecimal> amountMap = this.initAmountMap(startDate, endDate);
        for (InputInvoiceSelectFieldEnum entry : InputInvoiceSelectFieldEnum.values()) {
            String entityName = entry.getEntityName();
            String periodField = entry.getPeriodField();
            String orgField = entry.getOrgField();
            QFilter orgFilter = new QFilter(orgField, "in", (Object)orgList.toArray());
            QFilter startFilter = new QFilter(periodField, ">=", (Object)startDate);
            QFilter endFilter = new QFilter(periodField, "<", (Object)DateUtils.addMonth((Date)endDate, (int)1));
            QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter};
            DataSet entryCol = QueryServiceHelper.queryDataSet((String)("InvoiceTaxTrendCardPlugin.getInputAmount" + entityName), (String)entityName, (String)InputInvoiceSelectFieldEnum.getSelectField(entityName), (QFilter[])filters, null);
            this.setAmount(amountMap, entryCol, periodField, entry.getAmountField());
            entryCol.close();
        }
        return amountMap;
    }

    private void setAmount(Map<String, BigDecimal> amountMap, DataSet invoiceDataSet, String periodField, String amountField) {
        for (Row object : invoiceDataSet.copy()) {
            BigDecimal amount = object.getBigDecimal(amountField);
            Date invoiceDate = object.getDate(periodField);
            String dateStr = DateUtils.format((Date)invoiceDate, (String)"yyyy-MM");
            if (!amountMap.containsKey(dateStr)) continue;
            BigDecimal newAmount = amountMap.get(dateStr).add(amount);
            amountMap.put(dateStr, newAmount.setScale(2, 4));
        }
    }

    private Map<String, BigDecimal> getOutputAmount(List<Long> orgList, Date startDate, Date endDate) {
        Map<String, BigDecimal> amountMap = this.initAmountMap(startDate, endDate);
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgList.toArray());
        QFilter startFilter = new QFilter(INVOICE_DATE, ">=", (Object)startDate);
        QFilter endFilter = new QFilter(INVOICE_DATE, "<", (Object)DateUtils.addMonth((Date)endDate, (int)1));
        QFilter statusFilter = new QFilter(INVOICE_STATUS, "in", (Object)new String[]{"0", "3"});
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"InvoiceTaxTrendCardPlugin_getOutputAmount", (String)TDM_INVOICE_OUTPUT, (String)OUTPUR_SELECTFIELDS, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, statusFilter}, null);
        this.setAmount(amountMap, invoiceDataSet, INVOICE_DATE, TAX_AMOUNT);
        invoiceDataSet.close();
        return amountMap;
    }

    private Map<String, BigDecimal> initAmountMap(Date startDate, Date endDate) {
        List monthList = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
        LinkedHashMap<String, BigDecimal> amountMap = new LinkedHashMap<String, BigDecimal>(monthList.size());
        for (String month : monthList) {
            amountMap.put(month, BigDecimal.ZERO);
        }
        return amountMap;
    }

    private void drawChart(Map<String, BigDecimal> valueMap1, Map<String, BigDecimal> valueMap2) {
        PointLineChart chart = (PointLineChart)this.getControl(POINTLINE_CHARTAP);
        chart.clearData();
        List categorys = valueMap1.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        Axis xAxis = this.createCategoryAxis(chart, ResManager.loadKDString((String)"\u6708\u4efd", (String)"InvoiceTaxTrendCardPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        xAxis.setCategorys(categorys);
        List<BigDecimal> outputValues = valueMap1.entrySet().stream().map(e -> (BigDecimal)e.getValue()).collect(Collectors.toList());
        List<BigDecimal> inputValues = valueMap2.entrySet().stream().map(e -> (BigDecimal)e.getValue()).collect(Collectors.toList());
        this.createLine(chart, outputValues, inputValues);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setLegendVertical(false);
        chart.setShowLegend(true);
        chart.setMargin(Position.right, POSITION_VALUE);
        chart.setMargin(Position.top, POSITION_VALUE);
        chart.setMargin(Position.left, POSITION_VALUE);
        chart.setMargin(Position.bottom, POSITION_VALUE);
        chart.refresh();
    }

    private void createLine(PointLineChart chart, List<BigDecimal> outputValues, List<BigDecimal> inputValues) {
        ArrayList<BigDecimal> datas = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> lineData1 = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> lineData2 = new ArrayList<BigDecimal>();
        datas.addAll(outputValues);
        datas.addAll(inputValues);
        BigDecimal maxValue = (BigDecimal)Collections.max(datas);
        BigDecimal midValue = new BigDecimal(1000);
        if (maxValue.compareTo(midValue) > 0) {
            this.createValueAxis(chart, RMB_UNIT.get("2"));
            outputValues.forEach(output -> lineData1.add(output.divide(midValue, 2, 4)));
            inputValues.forEach(input -> lineData2.add(input.divide(midValue, 2, 4)));
        } else {
            this.createValueAxis(chart, RMB_UNIT.get("1"));
            outputValues.forEach(output -> lineData1.add((BigDecimal)output));
            outputValues.forEach(input -> lineData2.add((BigDecimal)input));
        }
        this.createLineSeries(chart, ResManager.loadKDString((String)"\u9500\u9879", (String)"InvoiceTaxTrendCardPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), lineData1, "#FFA940");
        this.createLineSeries(chart, ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u8fdb\u9879", (String)"InvoiceTaxTrendCardPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), lineData2, "#40A9FF");
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createXAxis(name, AxisType.category);
        axis.setPropValue("nameLocation", (Object)"end");
        axis.setPropValue("position", (Object)"bottom");
        return axis;
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createYAxis(name, AxisType.value);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }

    static {
        RMB_UNIT.put("1", ResManager.loadKDString((String)"\u5143", (String)"InvoiceTaxTrendCardPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        RMB_UNIT.put("2", ResManager.loadKDString((String)"\u5343\u5143", (String)"InvoiceTaxTrendCardPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        RMB_UNIT.put("3", ResManager.loadKDString((String)"\u4e07\u5143", (String)"InvoiceTaxTrendCardPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }
}

