/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.apphome;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class TdmAppHomePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String BASEDATA_ID = "fbasedataid";

    public void registerListener(EventObject e) {
        MulBasedataEdit orgMulBaseEdit = (MulBasedataEdit)this.getView().getControl(ORGS);
        orgMulBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().startsWith(ORGS)) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView());
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(orgId);
        this.getModel().setValue(ORGS, (Object)orgs.toArray());
        Date nowDate = DateUtils.getFirstDateOfMonth((Date)new Date());
        this.getModel().setValue(START_DATE, (Object)nowDate);
        this.getModel().setValue(END_DATE, (Object)nowDate);
        this.refreshPageCache();
    }

    private void refreshPageCache() {
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        ArrayList<Long> orgs = new ArrayList<Long>();
        for (DynamicObject object : orgCol) {
            DynamicObject org = object.getDynamicObject(BASEDATA_ID);
            orgs.add(org.getLong("id"));
        }
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        this.getPageCache().put(ORGS, SerializationUtils.toJsonString(orgs));
        this.getPageCache().put(START_DATE, DateUtils.format((Date)startDate));
        this.getPageCache().put(END_DATE, DateUtils.format((Date)endDate));
    }

    private void refreshPageView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{new HashMap()});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshPageView();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (this.verifyProperty(key)) {
            this.refreshPageCache();
            this.refreshPageView();
        }
    }

    private boolean verifyProperty(String key) {
        if (!(ORGS.equals(key) || START_DATE.equals(key) || END_DATE.equals(key))) {
            return false;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        if (orgs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TdmAppHomePlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (startDate == null || endDate == null || startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u5e74\u6708\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u521d\u59cb\u65e5\u671f\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"TdmAppHomePlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int months = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
        if (months > 6) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u67e5\u8be26\u4e2a\u6708\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TdmAppHomePlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

