/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.avgtaxrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AvgTaxRateFormPluginListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("editbatch".equals(e.getOperateKey())) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tdm_reftaxrate_dialog");
            param.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editbatch");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("editbatch".equals(event.getActionId()) && event.getReturnData() != null) {
            DynamicObject[] detailInfos;
            Map data = (Map)event.getReturnData();
            String type = (String)data.get("type");
            Date date = (Date)data.get("date");
            if (StringUtils.isEmpty((CharSequence)type) || date == null || CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection refTaxRateList = QueryServiceHelper.query((String)"tdm_ref_taxrate", (String)"id,number,taxationsys,taxareagroup,industrycode,taxcategory,activedate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if ("activedate".equalsIgnoreCase(type)) {
                for (DynamicObject dyo2 : refTaxRateList) {
                    if (dyo2.getDate("expdate").compareTo(date) > 0) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u8981\u5927\u4e8e\u751f\u6548\u65e5\u671f", (String)"AvgTaxRateFormPluginListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("expdate".equalsIgnoreCase(type)) {
                for (DynamicObject dyo2 : refTaxRateList) {
                    if (dyo2.getDate("activedate").compareTo(date) < 0) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u8981\u5927\u4e8e\u751f\u6548\u65e5\u671f", (String)"AvgTaxRateFormPluginListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            QFilter allFilter = new QFilter("id", "!=", (Object)0L);
            DynamicObjectCollection allDatas = QueryServiceHelper.query((String)"tdm_ref_taxrate", (String)"id,number,activedate,expdate,taxationsys,taxareagroup,industrycode,taxcategory", (QFilter[])allFilter.toArray());
            for (Object dyo3 : allDatas) {
                if (!ids.contains(dyo3.getLong("id"))) continue;
                dyo3.set(type, (Object)date);
            }
            Map<String, List<DynamicObject>> listMap = allDatas.stream().collect(Collectors.groupingBy(dyo -> dyo.getString("taxationsys").concat("#").concat(dyo.getString("taxareagroup")).concat("#").concat(dyo.getString("industrycode")).concat("#").concat(dyo.getString("taxcategory")).concat("#")));
            for (DynamicObject dyo4 : refTaxRateList) {
                long id = dyo4.getLong("id");
                dyo4.set(type, (Object)date);
                String key = dyo4.getString("taxationsys").concat("#").concat(dyo4.getString("taxareagroup")).concat("#").concat(dyo4.getString("industrycode")).concat("#").concat(dyo4.getString("taxcategory")).concat("#");
                List<DynamicObject> refTaxrates = listMap.getOrDefault(key, new ArrayList());
                boolean checkDate = this.checkDate(refTaxrates = refTaxrates.stream().filter(m -> m.getLong("id") != id).collect(Collectors.toList()), dyo4.getDate("activedate"), dyo4.getDate("expdate"));
                if (checkDate) continue;
                String msg = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6709\u6548\u671f\u5185\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e24\u4e2a\u53c2\u8003\u7a0e\u8d1f\u7387\u3002", (String)"AvgTaxRateFormPluginListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            for (DynamicObject detailInfo : detailInfos = BusinessDataServiceHelper.load((String)"tdm_ref_taxrate", (String)MetadataUtil.getAllSubFieldString((String)"tdm_ref_taxrate"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                detailInfo.set(type, (Object)date);
            }
            SaveServiceHelper.update((DynamicObject[])detailInfos);
            billList.refresh();
        }
    }

    private boolean checkDate(List<DynamicObject> tdmRefTaxrateList, Date activedate, Date expdate) {
        if (CollectionUtils.isEmpty(tdmRefTaxrateList)) {
            return true;
        }
        for (DynamicObject rate : tdmRefTaxrateList) {
            Date activedateDb = rate.getDate("activedate");
            Date expdateDb = rate.getDate("expdate");
            if (activedateDb.compareTo(expdate) > 0 || expdateDb.compareTo(activedate) < 0) continue;
            return false;
        }
        return true;
    }
}

