/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TriaBalanceFormQueryPlugin
extends AbstractReportListDataPlugin {
    private static String[] FIELDS = new String[]{"orgname", "accounttype", "billno", "balancename", "accountdimension", "openinglocalcurrency1", "openinglocalcurrency2", "debitlocalcurrency", "creditlocalcurrency", "sumdebitlocalcurrency", "sumcreditlocalcurrency", "closinglocalcurrency1", "closinglocalcurrency2", "datasource", "sourcesys"};
    private static DataType[] DATA_TYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType};
    private static String QUERY_FIELDS = "id,org.name,accountbookstype,billno,balance.name,debitlocalcurrency,creditlocalcurrency,debitlocalcurrencyi,creditlocalcurrencyi,openinglocalcurrency,closinglocalcurrency,datasource,sourcesys,openingbalancetype,closingbalancetype";
    private static String SUB_QUERY_FIELDS = "id,entryentity.accountdimension,entryentity.subopeninglocalcurrency,entryentity.debitcurrentamount,entryentity.creditcurrentamount,entryentity.sumdebitamount,entryentity.sumcreditamount,entryentity.subclosinglocalcurrency";
    private static final String BALANCE_TABLE_NAME = "tdm_balance_new";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return this.collectDateSet(filterInfo);
    }

    private List<QFilter> getFilters(FilterInfo filterInfo) {
        Date periodDate;
        String accountbookstype;
        DynamicObject org = (DynamicObject)filterInfo.getFilterItem("org").getValue();
        List bills = (List)filterInfo.getFilterItem("balance").getValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (org != null) {
            qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
        }
        if (CollectionUtils.isNotEmpty((Collection)bills)) {
            List billNos = bills.stream().map(o -> o.getString("number")).collect(Collectors.toList());
            qFilters.add(new QFilter("billno", "in", billNos));
        }
        if (StringUtils.isNotBlank((CharSequence)(accountbookstype = (String)filterInfo.getFilterItem("accountbookstype").getValue()))) {
            qFilters.add(new QFilter("accountbookstype", "=", (Object)accountbookstype));
        }
        if ((periodDate = (Date)filterInfo.getFilterItem("period").getValue()) != null) {
            String yearOfDate = String.valueOf(DateUtils.getYearOfDate((Date)periodDate));
            String monthOfDate = String.format("%02d", DateUtils.getMonthOfDate((Date)periodDate));
            qFilters.add(new QFilter("accountyear", "=", (Object)yearOfDate));
            qFilters.add(new QFilter("accountperiod", "=", (Object)monthOfDate));
        }
        String isAdjust = (String)filterInfo.getFilterItem("isadjust").getValue();
        qFilters.add(new QFilter("isadjust", "=", (Object)isAdjust));
        String adjPeri = (String)filterInfo.getFilterItem("adjperi").getValue();
        if (StringUtils.isNotBlank((CharSequence)adjPeri)) {
            qFilters.add(new QFilter("adjperi", "=", (Object)adjPeri));
        }
        return qFilters;
    }

    private DataSet collectDateSet(FilterInfo filterInfo) {
        List<QFilter> qFilters = this.getFilters(filterInfo);
        QFilter[] qFilter = new QFilter[qFilters.size()];
        qFilters.toArray(qFilter);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BALANCE_TABLE_NAME, (String)QUERY_FIELDS, (QFilter[])qFilter, (String)"billno");
        Boolean isShowAssistDimension = filterInfo.getFilterItem("showaccountdimension").getBoolean();
        DataSet subDataSet = null;
        if (isShowAssistDimension.booleanValue()) {
            subDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BALANCE_TABLE_NAME, (String)SUB_QUERY_FIELDS, (QFilter[])qFilter, null);
        }
        return this.dealDataSet(mainDataSet, subDataSet);
    }

    private DataSet dealDataSet(DataSet mainDataSet, DataSet subDataSet) {
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        this.buildMainData(mainDataSet, subDataSet, coll);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATA_TYPES);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSetCount = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        return dataSetCount;
    }

    private void buildMainData(DataSet mainDataSet, DataSet subDataSet, Collection<Object[]> coll) {
        Map<Long, Collection<Object[]>> entryDataMap = this.buildSubData(subDataSet);
        for (Row row : mainDataSet.copy()) {
            BigDecimal closingCurrency;
            BigDecimal openingCurrency;
            long id = row.getLong("id");
            String billNo = row.getString("billno");
            String orgName = row.getString("org.name");
            String accountbookstype = row.getString("accountbookstype");
            String balanceName = row.getString("balance.name");
            String dataSource = row.getString("datasource");
            String sourceSys = row.getString("sourcesys");
            BigDecimal openingLocalCurrency = row.getBigDecimal("openinglocalcurrency");
            String openingbalancetype = row.getString("openingbalancetype");
            if (StringUtils.isNotBlank((CharSequence)openingbalancetype) && ResManager.loadKDString((String)"\u501f", (String)"TriaBalanceFormQueryPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]).equals(openingbalancetype)) {
                openingCurrency = openingLocalCurrency.setScale(2, 4);
                openingLocalCurrency = BigDecimal.valueOf(0.0);
            } else if (StringUtils.isNotBlank((CharSequence)openingbalancetype) && ResManager.loadKDString((String)"\u8d37", (String)"TriaBalanceFormQueryPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]).equals(openingbalancetype)) {
                openingLocalCurrency = openingLocalCurrency.setScale(2, 4);
                openingCurrency = BigDecimal.valueOf(0.0);
            } else if (BigDecimal.ZERO.compareTo(openingLocalCurrency) <= 0) {
                openingCurrency = openingLocalCurrency.setScale(2, 4);
                openingLocalCurrency = BigDecimal.valueOf(0.0);
            } else {
                openingLocalCurrency = openingLocalCurrency.setScale(2, 4).abs();
                openingCurrency = BigDecimal.valueOf(0.0);
            }
            BigDecimal closingLocalCurrency = row.getBigDecimal("closinglocalcurrency");
            String closingbalancetype = row.getString("closingbalancetype");
            if (StringUtils.isNotBlank((CharSequence)closingbalancetype) && ResManager.loadKDString((String)"\u501f", (String)"TriaBalanceFormQueryPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]).equals(closingbalancetype)) {
                closingCurrency = closingLocalCurrency.setScale(2, 4);
                closingLocalCurrency = BigDecimal.valueOf(0.0);
            } else if (StringUtils.isNotBlank((CharSequence)closingbalancetype) && ResManager.loadKDString((String)"\u8d37", (String)"TriaBalanceFormQueryPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]).equals(closingbalancetype)) {
                closingLocalCurrency = closingLocalCurrency.setScale(2, 4);
                closingCurrency = BigDecimal.valueOf(0.0);
            } else if (BigDecimal.ZERO.compareTo(closingLocalCurrency) <= 0) {
                closingCurrency = closingLocalCurrency.setScale(2, 4);
                closingLocalCurrency = BigDecimal.valueOf(0.0);
            } else {
                closingLocalCurrency = closingLocalCurrency.setScale(2, 4).abs();
                closingCurrency = BigDecimal.valueOf(0.0);
            }
            BigDecimal debitCurrentCurrency = row.getBigDecimal("debitlocalcurrency").setScale(2, 4);
            BigDecimal creditCurrentCurrency = row.getBigDecimal("creditlocalcurrency").setScale(2, 4);
            BigDecimal debitCurrentCurrencyi = row.getBigDecimal("debitlocalcurrencyi").setScale(2, 4);
            BigDecimal creditCurrentCurrencyi = row.getBigDecimal("creditlocalcurrencyi").setScale(2, 4);
            Object[] billData = new Object[]{orgName, accountbookstype, billNo, balanceName, "", openingCurrency, openingLocalCurrency, debitCurrentCurrency, creditCurrentCurrency, debitCurrentCurrencyi, creditCurrentCurrencyi, closingCurrency, closingLocalCurrency, dataSource, sourceSys};
            coll.add(billData);
            this.addSubData(id, billData, entryDataMap, coll);
        }
    }

    protected Map<Long, Collection<Object[]>> buildSubData(DataSet subDataSet) {
        if (subDataSet == null) {
            return null;
        }
        HashMap<Long, Collection<Object[]>> entryDataMap = new HashMap<Long, Collection<Object[]>>(50);
        for (Row subRow : subDataSet.copy()) {
            BigDecimal subClosingCurrency;
            BigDecimal subOpeningCurrency;
            long id = subRow.getLong("id");
            String accountDimension = subRow.getString("entryentity.accountdimension");
            if (StringUtils.isBlank((CharSequence)accountDimension)) continue;
            BigDecimal subOpeningLocalCurrency = subRow.getBigDecimal("entryentity.subopeninglocalcurrency");
            if (BigDecimal.ZERO.compareTo(subOpeningLocalCurrency) <= 0) {
                subOpeningCurrency = subOpeningLocalCurrency.setScale(2, 4);
                subOpeningLocalCurrency = BigDecimal.valueOf(0.0);
            } else {
                subOpeningLocalCurrency = subOpeningLocalCurrency.setScale(2, 4).abs();
                subOpeningCurrency = BigDecimal.valueOf(0.0);
            }
            BigDecimal subDebitCurrentAmount = subRow.getBigDecimal("entryentity.debitcurrentamount").setScale(2, 4);
            BigDecimal subCreditCurrentAmount = subRow.getBigDecimal("entryentity.creditcurrentamount").setScale(2, 4);
            BigDecimal sumDebitAmount = subRow.getBigDecimal("entryentity.sumdebitamount").setScale(2, 4);
            BigDecimal sumCreditAmount = subRow.getBigDecimal("entryentity.sumcreditamount").setScale(2, 4);
            BigDecimal subClosingLocalCurrency = subRow.getBigDecimal("entryentity.subclosinglocalcurrency");
            if (BigDecimal.ZERO.compareTo(subClosingLocalCurrency) <= 0) {
                subClosingCurrency = subClosingLocalCurrency.setScale(2, 4);
                subClosingLocalCurrency = BigDecimal.valueOf(0.0);
            } else {
                subClosingLocalCurrency = subClosingLocalCurrency.setScale(2, 4).abs();
                subClosingCurrency = BigDecimal.valueOf(0.0);
            }
            ArrayList<Object[]> newColl = (ArrayList<Object[]>)entryDataMap.get(id);
            if (newColl == null) {
                newColl = new ArrayList<Object[]>(16);
                entryDataMap.put(id, newColl);
            }
            newColl.add(new Object[]{"", "", "", "", accountDimension, subOpeningCurrency, subOpeningLocalCurrency, subDebitCurrentAmount, subCreditCurrentAmount, sumDebitAmount, sumCreditAmount, subClosingCurrency, subClosingLocalCurrency, null, null});
        }
        return entryDataMap;
    }

    protected void addSubData(Long id, Object[] billData, Map<Long, Collection<Object[]>> entryDataMap, Collection<Object[]> coll) {
        if (entryDataMap == null || entryDataMap.get(id) == null) {
            return;
        }
        Collection<Object[]> entryList = entryDataMap.get(id);
        for (Object[] entry : entryList) {
            entry[13] = billData[13];
            entry[14] = billData[14];
            coll.add(entry);
        }
    }
}

