/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.balance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.JsonUtil;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.BalanceImportPlugin;
import org.apache.commons.lang.StringUtils;

public class TrialBalanceFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().startsWith("org")) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initFilter();
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        ReportQueryParam reportQueryParam = event.getQueryParam();
        Boolean isShowAssistDimension = reportQueryParam.getFilter().getFilterItem("showaccountdimension").getBoolean();
        if (!isShowAssistDimension.booleanValue()) {
            Iterator abstractReportColumnIterator = event.getColumns().iterator();
            while (abstractReportColumnIterator.hasNext()) {
                ReportColumn reportColumn;
                AbstractReportColumn abstractReportColumn = (AbstractReportColumn)abstractReportColumnIterator.next();
                if (!(abstractReportColumn instanceof ReportColumn) || !(reportColumn = (ReportColumn)abstractReportColumn).getFieldKey().equals("accountdimension")) continue;
                abstractReportColumnIterator.remove();
                break;
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        IDataModel model = this.getModel();
        List<String> list = Arrays.asList("org", "accountbookstype", "period", "balance", "showaccountdimension");
        for (String s : list) {
            if (!this.hasProperty(s)) continue;
            model.setValue(s, scheme.get(s));
        }
    }

    private boolean hasProperty(String name) {
        return this.getModel().getProperty(name) != null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        return this.verifyQueryParams(filterInfo);
    }

    private boolean verifyQueryParams(FilterInfo filterInfo) {
        if (this.getFilterOrg(filterInfo).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"TrialBalanceFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("period") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4", (String)"TrialBalanceFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getFilterOrg(FilterInfo filterInfo) {
        ArrayList<Long> result = new ArrayList<Long>();
        long orgId = filterInfo.getLong("org");
        if (orgId != 0L) {
            result.add(orgId);
        }
        return result;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = this.formatShowFilter(showFieldList, iDataModel);
            evt.setFormatedFilterString(msg);
        }
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = this.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"TrialBalanceFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TrialBalanceFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isAfterConfirm;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("donothingdelete".equals(operationKey) && !(isAfterConfirm = operate.getOption().tryGetVariableValue("afterconfirm", new RefObject()))) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            DynamicObject dynamicObject = (DynamicObject)reportQueryParam.getFilter().getFilterItem("org").getValue();
            Date periodDate = (Date)reportQueryParam.getFilter().getFilterItem("period").getValue();
            Boolean verifyResult = this.verifyQueryParams(reportQueryParam.getFilter());
            if (!verifyResult.booleanValue()) {
                args.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            if (dynamicObject != null) {
                String orgName = dynamicObject.getString("name");
                String period = DateUtils.format((Date)periodDate, (String)"yyyy-MM");
                List balance = (List)reportQueryParam.getFilter().getFilterItem("balance").getValue();
                if (CollectionUtils.isEmpty((Collection)balance)) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4f1a\u8ba1\u671f\u95f4\u201c%2$s\u201d\u62a5\u8868\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u786e\u8ba4\u522a\u9664\u8be5\u62a5\u8868\u6570\u636e\u5417\uff1f", (String)"TrialBalanceFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgName, period), MessageBoxOptions.YesNo, confirmCallBackListener);
                } else {
                    List billName = balance.stream().map(o -> o.getString("name")).collect(Collectors.toList());
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4f1a\u8ba1\u671f\u95f4\u201c%2$s\u201d\u79d1\u76ee\u201c%3$s\u201d\u62a5\u8868\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u786e\u8ba4\u522a\u9664\u8be5\u62a5\u8868\u6570\u636e\u5417\uff1f", (String)"TrialBalanceFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgName, period, String.join((CharSequence)",", billName)), MessageBoxOptions.YesNo, confirmCallBackListener);
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothingimport".equals(args.getOperateKey())) {
                this.importData();
            } else if ("donothingdelete".equals(args.getOperateKey())) {
                this.deleteData();
                this.getView().refresh();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"delete", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("donothingdelete", operateOption);
        }
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)"tdm_balance_new");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", Boolean.TRUE);
        map.put("ClassName", BalanceImportPlugin.class);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868", (String)"TrialBalanceFormPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    private void deleteData() {
        Date periodDate;
        ReportQueryParam reportQueryParam = this.getView().getQueryParam();
        DynamicObject dynamicObject = (DynamicObject)reportQueryParam.getFilter().getFilterItem("org").getValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String orgName = null;
        if (dynamicObject != null) {
            qFilters.add(new QFilter("org", "=", (Object)dynamicObject.getLong("id")));
            orgName = dynamicObject.getString("name");
        }
        if ((periodDate = (Date)reportQueryParam.getFilter().getFilterItem("period").getValue()) != null) {
            String yearOfDate = String.valueOf(DateUtils.getYearOfDate((Date)periodDate));
            String monthOfDate = String.format("%02d", DateUtils.getMonthOfDate((Date)periodDate));
            qFilters.add(new QFilter("accountyear", "=", (Object)yearOfDate));
            qFilters.add(new QFilter("accountperiod", "=", (Object)monthOfDate));
        }
        List balance = (List)reportQueryParam.getFilter().getFilterItem("balance").getValue();
        List billNos = null;
        if (!CollectionUtils.isEmpty((Collection)balance)) {
            billNos = balance.stream().map(o -> o.getString("number")).collect(Collectors.toList());
            qFilters.add(new QFilter("billno", "in", billNos));
        }
        String isAdjust = (String)reportQueryParam.getFilter().getFilterItem("isadjust").getValue();
        String adjPeri = (String)reportQueryParam.getFilter().getFilterItem("adjperi").getValue();
        if (StringUtils.isNotEmpty((String)isAdjust)) {
            qFilters.add(new QFilter("isadjust", "=", (Object)isAdjust));
        }
        if (StringUtils.isNotEmpty((String)adjPeri)) {
            qFilters.add(new QFilter("adjperi", "=", (Object)adjPeri));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return;
        }
        QFilter[] qFilterArray = new QFilter[qFilters.size()];
        qFilters.toArray(qFilterArray);
        int num = DeleteServiceHelper.delete((String)"tdm_balance_new", (QFilter[])qFilterArray);
        if (num == 0) {
            String period = DateUtils.format((Date)periodDate, (String)"yyyy-MM");
            if (CollectionUtils.isEmpty(billNos)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u4f1a\u8ba1\u671f\u95f4\u201c%2$s\u201d\u4e2d\u62a5\u8868\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664", (String)"TrialBalanceFormPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgName, period));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u4f1a\u8ba1\u671f\u95f4\u201c%2$s\u201d\u4e0e\u79d1\u76ee\u201c%3$s\u201d\u4e2d\u62a5\u8868\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664", (String)"TrialBalanceFormPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgName, period, String.join((CharSequence)",", billNos)));
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"TrialBalanceFormPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void initFilter() {
        FilterInfo filter = new FilterInfo();
        Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView());
        filter.addFilterItem("org", (Object)orgId);
        filter.addFilterItem("period", (Object)new Date());
        filter.addFilterItem("showaccountdimension", (Object)Boolean.FALSE);
        this.getView().getModel().setValue("org", (Object)orgId);
        this.getQueryParam().setFilter(filter);
    }
}

