/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.constant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.extplugin.PluginProxy;
import kd.taxc.tdm.business.subplugin.IFinanceRptFieldSubPlugin;
import kd.taxc.tdm.business.subplugin.impl.DefaultFinanceRptFieldSubPlugin;

public enum FinanceReportMappingEnum {
    LRB("lrb", "tdm_finance_lrb", "reportitem.id", "id,reportitem,bqje,bnljje", Arrays.asList("bqje", "bnljje")),
    HBLRB("hblrb", "tdm_finance_hblrb", "reportitem.id", "id,reportitem,bqje,bnljje", Arrays.asList("bqje", "bnljje")),
    XJLLB("xjllb", "tdm_finance_xjllb", "reportitem.id", "id,reportitem,bqje,bndljje", Arrays.asList("bqje", "bndljje")),
    HBXJLLB("hbxjllb", "tdm_finance_hbxjllb", "reportitem.id", "id,reportitem,bqje,sqje", Arrays.asList("bqje", "sqje")),
    ZCFZB("zcfzb", "tdm_finance_zcfzb", "reportitem.id", "id,reportitem,qmye,ncye", Arrays.asList("qmye", "ncye")),
    HBZCFZB("hbzcfzb", "tdm_finance_hbzcfzb", "reportitem.id", "id,reportitem,qmye,snnmye", Arrays.asList("qmye", "snnmye")),
    SYZQYBDB("syzqybdb", "tdm_fanance_qybdb", "reportitem.id", "id,reportitem,bnsszb,bnyxg,bnyxz,bnqtqygj,bnzbgj,bnjkcg,bnqtzhqy,bnzxcb,bnyygj,bnwfplr,bnsyzqyhj,snsszb,snyxg,snyxz,snqtqygj,snzbgj,snjkcg,snqtzhqy,snzxcb,snyygj,snwfplr,snsyzqyhj", Arrays.asList("bnsszb", "bnyxg", "bnyxz", "bnqtqygj", "bnzbgj", "bnjkcg", "bnqtzhqy", "bnzxcb", "bnyygj", "bnwfplr", "bnsyzqyhj", "snsszb", "snyxg", "snyxz", "snqtqygj", "snzbgj", "snjkcg", "snqtzhqy", "snzxcb", "snyygj", "snwfplr", "snsyzqyhj")),
    HBSYZQYBDB("hbsyzqybdb", "tdm_fanance_hbqybdb", "reportitem.id", "id,reportitem,bnsszb,bnyxg,bnyxz,bnqtqygj,bnzbgj,bnjkcg,bnqtzhqy,bnzxcb,bnyygj,bnybfxzb,bnwfplr,bnxj,bnssgdqy,bnsyzqyhj,snsszb,snyxg,snyxz,snqtqygj,snzbgj,snjkcg,snqtzhqy,snzxcb,snyygj,snybfxzb,snwfplr,snxj,snssgdqy,snsyzqyhj", Arrays.asList("bnsszb", "bnyxg", "bnyxz", "bnqtqygj", "bnzbgj", "bnjkcg", "bnqtzhqy", "bnzxcb", "bnyygj", "bnybfxzb", "bnwfplr", "bnxj", "bnssgdqy", "bnsyzqyhj", "snsszb", "snyxg", "snyxz", "snqtqygj", "snzbgj", "snjkcg", "snqtzhqy", "snzxcb", "snyygj", "snybfxzb", "snwfplr", "snxj", "snssgdqy", "snsyzqyhj")),
    BBFZ("bbfz", "tdm_finance_attachment", "", "", null),
    HBBBFZ("hbbbfz", "tdm_finance_attachment", "", "", null);

    private String type;
    private String entityName;
    private String rowField;
    private String selectField;
    private List<String> amountFields;

    private FinanceReportMappingEnum(String type, String entityName, String rowField, String selectField, List<String> amountFields) {
        this.type = type;
        this.entityName = entityName;
        this.rowField = rowField;
        this.selectField = selectField;
        this.amountFields = amountFields;
    }

    public static String getEntityNameByType(String type) {
        for (FinanceReportMappingEnum value : FinanceReportMappingEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value.getEntityName();
        }
        return null;
    }

    public static String getRowFieldByType(String type) {
        for (FinanceReportMappingEnum value : FinanceReportMappingEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value.getRowField();
        }
        return null;
    }

    public static String getSelectFieldByType(String type) {
        for (FinanceReportMappingEnum value : FinanceReportMappingEnum.values()) {
            if (!value.getType().equals(type)) continue;
            StringBuilder selectField = new StringBuilder(value.getSelectField());
            List<String> subFieldList = FinanceReportMappingEnum.getSubPluginAmountFieldList(type);
            if (subFieldList != null && subFieldList.size() > 0) {
                selectField.append(',').append(String.join((CharSequence)",", subFieldList));
            }
            return selectField.toString();
        }
        return null;
    }

    public static List<String> getAmountFieldByType(String type) {
        for (FinanceReportMappingEnum value : FinanceReportMappingEnum.values()) {
            if (!value.getType().equals(type)) continue;
            ArrayList<String> fieldList = new ArrayList<String>();
            fieldList.addAll(value.getAmountFields());
            List<String> subFieldList = FinanceReportMappingEnum.getSubPluginAmountFieldList(type);
            if (subFieldList != null && subFieldList.size() > 0) {
                fieldList.addAll(subFieldList);
            }
            return fieldList;
        }
        return null;
    }

    private static List<String> getSubPluginAmountFieldList(String rptType) {
        ArrayList<String> fieldList = new ArrayList<String>();
        DefaultFinanceRptFieldSubPlugin amountFieldSubPlugin = new DefaultFinanceRptFieldSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)amountFieldSubPlugin, IFinanceRptFieldSubPlugin.class, (String)"kd.taxc.tdm.business.subplugin.IFinanceRptFieldSubPlugin", null);
        List resultList = pluginProxy.callReplaceIfPresent(p -> p.getAmountFieldList(rptType));
        if (resultList != null && resultList.size() > 0) {
            for (List fields : resultList) {
                fieldList.addAll(fields);
            }
        }
        return fieldList;
    }

    public String getType() {
        return this.type;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getRowField() {
        return this.rowField;
    }

    public String getSelectField() {
        return this.selectField;
    }

    public List<String> getAmountFields() {
        return this.amountFields;
    }
}

