/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.datacompare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareFormEnum;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.ObjectUtils;
import kd.taxc.tdm.formplugin.datacompare.utils.DataComparePluginHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataCompareOpFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DataCompareOpFormPlugin.class);
    private static final String DOCOMPARE_PERMITEM = "3S1UP25WBS4E";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = this.getDefaultOrg();
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            this.getModel().setValue("org", (Object)Collections.singleton(orgId).toArray());
        }
        this.getModel().setValue("startperiod", (Object)DateUtils.addMonth((Date)new Date(), (int)-1));
        this.getModel().setValue("endperiod", (Object)DateUtils.addMonth((Date)new Date(), (int)-1));
        DataComparePluginHelper.initBookTypeControl(this.getView(), "booktype", "id");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit account = (BasedataEdit)this.getView().getControl("account");
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("account".equalsIgnoreCase(key)) {
            QFilter filter1 = new QFilter("parent.id", "=", (Object)" ");
            QFilter filter2 = new QFilter("parent.id", "is null", null);
            QFilter filters = filter1.or(filter2);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.getListFilterParameter().setFilter(filters);
        } else if ("org".equalsIgnoreCase(key)) {
            List<Long> orgIds = this.getPermOrg();
            QFilter filters = new QFilter("id", "in", orgIds);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    protected Long getDefaultOrg() {
        Long orgid = null;
        List<Long> orgIds = this.getPermOrg();
        if (orgIds.size() > 0) {
            orgid = orgIds.contains(RequestContext.get().getOrgId()) ? Long.valueOf(RequestContext.get().getOrgId()) : orgIds.get(0);
        }
        return orgid;
    }

    protected List<Long> getPermOrg() {
        long userId = RequestContext.get().getCurrUserId();
        IFormView view = this.getView().getParentView();
        if (view != null) {
            TaxResult result;
            String appNumber = view.getFormShowParameter().getAppId();
            String appId = null;
            String entityid = view.getEntityId();
            if (view instanceof ListView) {
                entityid = ((ListView)view).getBillFormId();
            }
            if (!StringUtils.isBlank((CharSequence)appNumber)) {
                try {
                    appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
                }
                catch (Exception ex) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                    appId = mainEntityType.getAppId();
                }
            }
            return CollectionUtils.isNotEmpty((Collection)((Collection)(result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)appId, (String)entityid, (String)DOCOMPARE_PERMITEM, (String)"10")).getData())) ? (List)result.getData() : new ArrayList(0);
        }
        return new ArrayList<Long>(0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("docompare")) {
            String formid = (String)this.getView().getFormShowParameter().getCustomParam("formid");
            if (StringUtils.isEmpty((CharSequence)formid) || DataCompareFormEnum.getEnum((String)formid) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u5bf9\u5931\u8d25\uff0c\u6570\u636e\u6bd4\u5bf9\u65b9\u6848\u83b7\u53d6\u5931\u8d25", (String)"DataCompareOpFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date startPeriod = (Date)this.getModel().getValue("startperiod");
            Date endPeriod = (Date)this.getModel().getValue("endperiod");
            if (!ObjectUtils.isEmpty((Object)startPeriod) && !ObjectUtils.isEmpty((Object)endPeriod) && startPeriod.after(endPeriod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u4f1a\u8ba1\u671f\u95f4\u6b62", (String)"DataCompareOpFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && args.getOperateKey().equals("docompare")) {
            if (this.checkDuplicateTask()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("docompare", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\u8303\u56f4\u7684\u6267\u884c\u4e2d\u4efb\u52a1\uff0c\u786e\u8ba4\u7ee7\u7eed\u6267\u884c\u5f53\u524d\u6570\u636e\u6bd4\u5bf9\u4efb\u52a1\uff1f", (String)"DataCompareOpFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.submitDataCompareJob();
            }
        }
    }

    private void submitDataCompareJob() {
        try {
            Map<String, Object> params = this.getCompareParams();
            DataCompareBizBusiness.submitDataCompareJob(params);
            String msg = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6570\u636e\u6bd4\u5bf9\u4efb\u52a1\uff0c\u70b9\u51fb\u6570\u636e\u6bd4\u5bf9\u7ed3\u679c\u6309\u94ae\u67e5\u770b\u4efb\u52a1\u72b6\u6001\u3002", (String)"DataCompareOpFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.getView().returnDataToParent((Object)msg);
            this.getView().setReturnData((Object)msg);
            this.getView().close();
        }
        catch (Exception e) {
            logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011\u751f\u6210\u6570\u636e\u6bd4\u5bf9\u4efb\u52a1\u5931\u8d25\u3002", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            String msg = ResManager.loadKDString((String)"\u751f\u6210\u6570\u636e\u6bd4\u5bf9\u4efb\u52a1\u5931\u8d25\u3002", (String)"DataCompareOpFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if ("docompare".equalsIgnoreCase(e.getCallBackId()) && isOK) {
            this.submitDataCompareJob();
        }
    }

    private boolean checkDuplicateTask() {
        Map<String, Object> params = this.getCompareParams();
        Long schemeid = (Long)params.get("schemeid");
        DynamicObjectCollection coll = DataCompareDataBusiness.getOnTheWayResult((Long)schemeid);
        String dataRangeText = null;
        for (DynamicObject result : coll) {
            Map dataRange;
            dataRangeText = result.getString("datarange_tag");
            if (!StringUtils.isNotBlank((CharSequence)dataRangeText) || !this.hasDuplicateDataRange(dataRange = (Map)SerializationUtils.fromJsonString((String)dataRangeText, HashMap.class), params)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDuplicateDataRange(Map<String, Object> dataRange, Map<String, Object> params) {
        List orgIds = (List)params.get("orgIds");
        List bookTypeIds = (List)params.get("bookTypeIds");
        List periodIds = (List)params.get("periodIds");
        List rootAccountNumbers = (List)params.get("rootAccountNumbers");
        List orgIds_db = ObjectUtils.toLongList((List)((List)dataRange.get("orgIds")));
        List bookTypeIds_db = ObjectUtils.toLongList((List)((List)dataRange.get("bookTypeIds")));
        List periodIds_db = ObjectUtils.toLongList((List)((List)dataRange.get("periodIds")));
        List rootAccountNumbers_db = (List)dataRange.get("rootAccountNumbers");
        orgIds.retainAll(orgIds_db);
        bookTypeIds.retainAll(bookTypeIds_db);
        periodIds.retainAll(periodIds_db);
        if (orgIds.size() > 0 && bookTypeIds.size() > 0 && periodIds.size() > 0) {
            if (CollectionUtils.isEmpty((Collection)rootAccountNumbers) || CollectionUtils.isEmpty((Collection)rootAccountNumbers_db)) {
                return true;
            }
            rootAccountNumbers.retainAll(rootAccountNumbers_db);
            if (rootAccountNumbers.size() > 0) {
                return true;
            }
        }
        return false;
    }

    protected Map<String, Object> getCompareParams() {
        List accounts;
        HashMap<String, Object> compareParams = new HashMap<String, Object>();
        String entityid = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        compareParams.put("schemeid", DataCompareFormEnum.getEnum((String)entityid).getScheme().getId());
        List orgs = (List)this.getModel().getValue("org");
        if (CollectionUtils.isNotEmpty((Collection)orgs)) {
            List orgIds = orgs.stream().map(v -> v.getLong("fbasedataid.id")).collect(Collectors.toList());
            compareParams.put("orgIds", orgIds);
        }
        Date startPeriodDate = this.getModel().getDataEntity().getDate("startperiod");
        String startPeriod = DateUtils.format((Date)startPeriodDate, (String)"yyyyMM");
        compareParams.put("startPeriod", startPeriod);
        Date endPeriodDate = this.getModel().getDataEntity().getDate("endperiod");
        String endPeriod = DateUtils.format((Date)endPeriodDate, (String)"yyyyMM");
        compareParams.put("endPeriod", endPeriod);
        DynamicObjectCollection periods = DataCompareDataBusiness.getPeriods((String)startPeriod, (String)endPeriod);
        List periodIds = periods.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        compareParams.put("periodIds", periodIds);
        String bookTypes = this.getModel().getDataEntity().getString("booktype");
        if (StringUtils.isNotEmpty((CharSequence)bookTypes)) {
            List<String> idList = Arrays.asList(bookTypes.split(","));
            List bookTypeIds = idList.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v)).map(v -> Long.valueOf(v)).collect(Collectors.toList());
            compareParams.put("bookTypeIds", bookTypeIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(accounts = (List)this.getModel().getValue("account")))) {
            List rootAccountNumbers = accounts.stream().map(v -> v.getString("fbasedataid.number")).collect(Collectors.toList());
            compareParams.put("rootAccountNumbers", rootAccountNumbers);
        }
        return compareParams;
    }
}

