/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.datacompare;

import java.util.Arrays;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.report.ReportShowParameter;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareFormEnum;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeConfig;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeEnum;
import org.apache.commons.lang3.StringUtils;

public class DataCompareResultListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List listFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn fc : listFilterColumns) {
            String entryEntity = fc.getFieldName();
            if (!entryEntity.equals("scheme.name")) continue;
            String formid = (String)this.getView().getFormShowParameter().getCustomParam("formid");
            DataCompareFormEnum formEnum = DataCompareFormEnum.getEnum((String)formid);
            if (!StringUtils.isNotEmpty((CharSequence)formid) || formEnum == null) continue;
            fc.setDefaultValue(String.valueOf(formEnum.getScheme().getId()));
        }
        List<String> hideList = Arrays.asList("billstatus", "creator.number", "creator.name", "createtime", "modifier.number", "modifier.name", "modifytime", "auditor.number", "auditor.name", "auditdate");
        args.getSchemeFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getCommonFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            this.showReportPage();
        }
    }

    protected void showReportPage() {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject dynamicObject = DataCompareDataBusiness.loadSingle((Long)pkid, (String)"tdm_dc_result");
        if (dynamicObject != null) {
            long schemeId = dynamicObject.getLong("scheme.id");
            DataCompareSchemeConfig config = DataCompareSchemeEnum.getEnum((Long)schemeId).getConfig();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(config.getReportFormId());
            showParameter.setCustomParam("resultid", (Object)pkid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("viewlog".equalsIgnoreCase(operate.getOperateKey()) && args.getListSelectedData().getPrimaryKeyValues().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u65e5\u5fd7\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DataCompareResultListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "viewlog".equalsIgnoreCase(args.getOperateKey())) {
            Long pkid = (Long)args.getOperationResult().getSuccessPkIds().get(0);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tdm_dc_result_logform");
            showParameter.setCustomParam("resultid", (Object)pkid);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }
}

