/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.datacompare;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.ResultLogStateEnum;
import kd.taxc.tdm.business.datacompare.enums.ResultStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataCompareResultLogPlugin
extends AbstractFormPlugin {
    private static String[] COLUMNS = new String[]{"org", "period", "booktype", "state", "starttime", "endtime", "source_count", "tar_count"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadRangeData();
        this.loadLogData();
    }

    private void loadRangeData() {
        this.getModel().deleteEntryData("entryentity");
        Long resultid = (Long)this.getView().getFormShowParameter().getCustomParam("resultid");
        DynamicObject result = DataCompareDataBusiness.loadSingle((Long)resultid, (String)"tdm_dc_result");
        String dataRangeText = result.getString("datarange_tag");
        if (StringUtils.isNotBlank((CharSequence)dataRangeText)) {
            Map dataRange = (Map)SerializationUtils.fromJsonString((String)dataRangeText, HashMap.class);
            List orgIds_db = (List)dataRange.get("orgIds");
            List bookTypeIds_db = (List)dataRange.get("bookTypeIds");
            List rootAccountNumbers_db = (List)dataRange.get("rootAccountNumbers");
            String startPeriod = (String)dataRange.get("startPeriod");
            String endPeriod = (String)dataRange.get("endPeriod");
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("paramname", (Object)ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"DataCompareResultLogPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex);
            List orgIds = orgIds_db.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            DynamicObjectCollection coll = DataCompareDataBusiness.queryOrgList(orgIds);
            String orgAlias = coll.stream().map(v -> v.getString("name")).collect(Collectors.joining(";"));
            this.getModel().setValue("paramvalue", (Object)orgAlias, rowIndex);
            rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("paramname", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"DataCompareResultLogPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex);
            this.getModel().setValue("paramvalue", (Object)(startPeriod + "~" + endPeriod), rowIndex);
            rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("paramname", (Object)ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b", (String)"DataCompareResultLogPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex);
            List bookTypeIds = bookTypeIds_db.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            Map bookTypeIdsMap = DataCompareDataBusiness.getAccountbookstypes(bookTypeIds);
            String bookTypeAlias = bookTypeIdsMap.values().stream().map(v -> v.getString("name")).collect(Collectors.joining(";"));
            this.getModel().setValue("paramvalue", (Object)bookTypeAlias, rowIndex);
            rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("paramname", (Object)ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataCompareResultLogPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), rowIndex);
            String accountNumberAlias = null;
            if (CollectionUtils.isNotEmpty((Collection)rootAccountNumbers_db)) {
                accountNumberAlias = rootAccountNumbers_db.stream().collect(Collectors.joining(";"));
            }
            this.getModel().setValue("paramvalue", accountNumberAlias, rowIndex);
        }
        this.getModel().setValue("billno", (Object)result.getString("billno"));
        this.getModel().setValue("scheme", (Object)result.getDynamicObject("scheme"));
        this.getModel().setValue("errormsg", (Object)result.getString("errormsg_tag"));
    }

    private void loadLogData() {
        this.getModel().deleteEntryData("entrylog");
        Long resultid = (Long)this.getView().getFormShowParameter().getCustomParam("resultid");
        DynamicObjectCollection coll = DataCompareDataBusiness.queryResultLogList((Long)resultid);
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        this.getModel().beginInit();
        TableValueSetter vs = this.getTableValueSetter();
        DynamicObject obj = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            obj = (DynamicObject)coll.get(i);
            this.loadRowData(obj, vs);
            int rowCount = vs.getCount();
            if (rowCount < 1000) continue;
            model.batchCreateNewEntryRow("entrylog", vs);
            vs = this.getTableValueSetter();
        }
        int rowCount = vs.getCount();
        if (rowCount > 0) {
            model.batchCreateNewEntryRow("entrylog", vs);
        }
        this.getModel().endInit();
        this.getView().updateView("entrylog");
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org", new Object[0]);
        vs.addField("period", new Object[0]);
        vs.addField("booktype", new Object[0]);
        vs.addField("state", new Object[0]);
        vs.addField("starttime", new Object[0]);
        vs.addField("endtime", new Object[0]);
        vs.addField("source_count", new Object[0]);
        vs.addField("tar_count", new Object[0]);
        return vs;
    }

    private void loadRowData(DynamicObject obj, TableValueSetter vs) {
        List fields = vs.getFields();
        Object[] values = new Object[fields.size()];
        String dataRangeStr = obj.getString("datarange_tag");
        if (StringUtils.isNotBlank((CharSequence)dataRangeStr)) {
            Map dataRange = (Map)SerializationUtils.fromJsonString((String)dataRangeStr, HashMap.class);
            values[0] = dataRange.get("orgName");
            values[1] = dataRange.get("periodNumber");
            values[2] = dataRange.get("bookTypeName");
        }
        values[3] = ResultLogStateEnum.getName((String)obj.getString("state"));
        values[4] = obj.get("starttime");
        values[5] = obj.get("endtime");
        values[6] = obj.get("source_count");
        values[7] = obj.get("tar_count");
        vs.addRow(values);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("refreshdata".equalsIgnoreCase(args.getOperateKey())) {
                this.loadRangeData();
                this.loadLogData();
            } else if ("retry".equalsIgnoreCase(args.getOperateKey())) {
                this.doRetry();
            }
        }
    }

    private void doRetry() {
        Long resultid = (Long)this.getView().getFormShowParameter().getCustomParam("resultid");
        DynamicObject result = DataCompareDataBusiness.loadSingle((Long)resultid, (String)"tdm_dc_result");
        if (!ResultStateEnum.FAIL.getValue().equalsIgnoreCase(result.getString("state"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6570\u636e\u6bd4\u5bf9\u7ed3\u679c\u53ef\u4ee5\u5931\u8d25\u91cd\u8bd5\u3002", (String)"DataCompareResultLogPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        HashMap<String, Long> params = new HashMap<String, Long>(10);
        params.put("resultid", result.getLong("id"));
        params.put("schemeid", result.getLong("scheme.id"));
        DataCompareBizBusiness.submitResultRetryJob(params);
        String msg = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6570\u636e\u6bd4\u5bf9\u91cd\u8bd5\u4efb\u52a1\uff0c\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u67e5\u770b\u4efb\u52a1\u72b6\u6001\u3002", (String)"DataCompareResultLogPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }
}

