/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.datacompare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareStateEnum;
import kd.taxc.tdm.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class VoucherReportFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit account = (MulBasedataEdit)this.getView().getControl("account");
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initFilter();
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
        filter.search();
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String states;
        List accounts;
        String booktypes;
        StringBuilder formatDisplay = new StringBuilder();
        List orgs = (List)this.getModel().getValue("org");
        if (CollectionUtils.isNotEmpty((Collection)orgs)) {
            String orgAlias = String.join((CharSequence)";", orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList()));
            String orgFormat = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%s", (String)"VoucherReportFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[]{orgAlias});
            formatDisplay.append(orgFormat).append(";");
        }
        if (StringUtils.isNotBlank((CharSequence)(booktypes = (String)this.getModel().getValue("booktype")))) {
            String booktypeAlias = Stream.of(booktypes.split(",")).filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.joining(";"));
            String booktypeFormat = ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b:%s", (String)"VoucherReportFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[]{booktypeAlias});
            formatDisplay.append(booktypeFormat).append(";");
        }
        Date startperiod = (Date)this.getModel().getValue("startperiod");
        Date endperiod = (Date)this.getModel().getValue("endperiod");
        if (startperiod != null && endperiod != null) {
            String periodFormat = String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4:%1$s ~ %2$s", (String)"VoucherReportFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), DateUtils.format((Date)startperiod, (String)"yyyy-MM"), DateUtils.format((Date)endperiod, (String)"yyyy-MM"));
            formatDisplay.append(periodFormat).append(";");
        }
        if (CollectionUtils.isNotEmpty((Collection)(accounts = (List)this.getModel().getValue("account")))) {
            String accountAlias = String.join((CharSequence)";", accounts.stream().map(v -> v.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList()));
            String accountFormat = ResManager.loadKDString((String)"\u79d1\u76ee:%s", (String)"VoucherReportFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[]{accountAlias});
            formatDisplay.append(accountFormat).append(";");
        }
        if (StringUtils.isNotBlank((CharSequence)(states = (String)this.getModel().getValue("statelist")))) {
            String stateAlias = Stream.of(states.split(",")).filter(v -> StringUtils.isNotBlank((CharSequence)v)).map(v -> DataCompareStateEnum.getName((String)v)).collect(Collectors.joining(";"));
            String stateFormat = ResManager.loadKDString((String)"\u6bd4\u5bf9\u7ed3\u679c:%s", (String)"VoucherReportFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[]{stateAlias});
            formatDisplay.append(stateFormat).append(";");
        }
        if (formatDisplay.length() > 0) {
            evt.setFormatedFilterString(formatDisplay.substring(0, formatDisplay.length() - 1));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("resultid", this.getView().getFormShowParameter().getCustomParam("resultid"));
        this.getQueryParam().setCustomParam(customParams);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long resultId;
        Map dataRange;
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("account".equalsIgnoreCase(propertyName)) {
            QFilter filter1 = new QFilter("parent.id", "=", (Object)" ");
            QFilter filter2 = new QFilter("parent.id", "is null", null);
            QFilter filters = filter1.or(filter2);
            Long resultId2 = (Long)this.getView().getFormShowParameter().getCustomParam("resultid");
            Map dataRange2 = DataCompareDataBusiness.getDataRange((Long)resultId2);
            if (dataRange2 != null && CollectionUtils.isNotEmpty((Collection)((Collection)dataRange2.get("rootAccountNumbers")))) {
                QFilter filter3 = new QFilter("number", "in", dataRange2.get("rootAccountNumbers"));
                filters.and(filter3);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.getListFilterParameter().setFilter(filters);
        } else if ("org".equalsIgnoreCase(propertyName) && (dataRange = DataCompareDataBusiness.getDataRange((Long)(resultId = (Long)this.getView().getFormShowParameter().getCustomParam("resultid")))) != null && CollectionUtils.isNotEmpty((Collection)((Collection)dataRange.get("orgIds")))) {
            QFilter filters = new QFilter("id", "in", dataRange.get("orgIds"));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if ("state".equals(fieldName)) {
            int rowIndex = args.getRowIndex();
            ReportList reportList = (ReportList)args.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            this.showVoucherDetailReport(rowData);
        }
    }

    protected void showVoucherDetailReport(DynamicObject rowData) {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tdm_dc_voucherdetail_rpt");
        showParameter.setCustomParam("resultid", this.getView().getFormShowParameter().getCustomParam("resultid"));
        showParameter.setCustomParam("totalid", (Object)rowData.getLong("id"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        IDataModel model = this.getModel();
        List<String> list = Arrays.asList("org", "booktype", "startperiod", "endperiod", "account", "statelist");
        for (String s : list) {
            if (!this.hasProperty(s)) continue;
            model.setValue(s, scheme.get(s));
        }
    }

    private boolean hasProperty(String name) {
        return this.getModel().getProperty(name) != null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        return this.verifyQueryParams(filterInfo);
    }

    private boolean verifyQueryParams(FilterInfo filterInfo) {
        if (filterInfo.getDate("startperiod") != null && filterInfo.getDate("endperiod") != null && filterInfo.getDate("startperiod").after(filterInfo.getDate("endperiod"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u671f\u95f4\u6b62", (String)"VoucherReportFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initFilter() {
        FilterInfo filter = new FilterInfo();
        this.getQueryParam().setFilter(filter);
        Long resultId = (Long)this.getView().getFormShowParameter().getCustomParam("resultid");
        Map dataRange = DataCompareDataBusiness.getDataRange((Long)resultId);
        this.initBookTypeControl(dataRange);
        this.initDateControl(dataRange);
    }

    private void initDateControl(Map<String, Object> dataRange) {
        if (dataRange != null) {
            String startPeriod = (String)dataRange.get("startPeriod");
            String endPeriod = (String)dataRange.get("endPeriod");
            DateEdit startperiodControl = (DateEdit)this.getView().getControl("startperiod");
            startperiodControl.setMinDate(DateUtils.stringToDate((String)startPeriod, (String)"yyyyMM"));
            startperiodControl.setMaxDate(DateUtils.stringToDate((String)endPeriod, (String)"yyyyMM"));
            DateEdit endperiodControl = (DateEdit)this.getView().getControl("endperiod");
            endperiodControl.setMinDate(DateUtils.stringToDate((String)startPeriod, (String)"yyyyMM"));
            endperiodControl.setMaxDate(DateUtils.stringToDate((String)endPeriod, (String)"yyyyMM"));
        }
    }

    private void initBookTypeControl(Map<String, Object> dataRange) {
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("booktype");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        Map booktypeMap = DataCompareDataBusiness.getAccountbookstypes(null);
        for (Map.Entry entry : booktypeMap.entrySet()) {
            List bookTypeIds;
            if (dataRange != null && CollectionUtils.isNotEmpty((Collection)((Collection)dataRange.get("bookTypeIds"))) && !(bookTypeIds = (List)dataRange.get("bookTypeIds")).contains(entry.getKey())) continue;
            data.add(new ComboItem(new LocaleString(((DynamicObject)entry.getValue()).getString("name")), String.valueOf(((DynamicObject)entry.getValue()).getString("name"))));
        }
        mulComboEdit.setComboItems(data);
    }
}

